<?php

use Illuminate\Support\Facades\Route;
use Modules\LiveChat\Http\Controllers\LiveChatController;
use Modules\LiveChat\Http\Controllers\MessageController;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
 */

Route::prefix('admin')->middleware(['auth.routes'])->group(function () {
    Route::controller(LiveChatController::class)->group(function () {
        Route::get('/live-chat', 'index')->name('livechat.index')->middleware('PermissionCheck:livechat_read');
        Route::get('/live-chat-settings', 'setting')->name('livechat.setting')->middleware('PermissionCheck:livechat_settings');
        Route::post('/live-chat-settings', 'settingUpdate')->name('livechat.setting.update')->middleware('PermissionCheck:livechat_settings');
        Route::get('/chat-list', 'chatList')->name('livechat.chat_list');
    });
    Route::controller(MessageController::class)->group(function () {
        Route::get('/live-chat/{id}', 'chat')->name('livechat.chat')->middleware('PermissionCheck:livechat_read');
        Route::post('/live-chat/store/{id}', 'store')->name('livechat.store')->middleware('PermissionCheck:livechat_create');
    });

});

// student live chat
Route::prefix('student')->middleware(['student', 'auth', 'verified'])->group(function () {
    Route::controller(LiveChatController::class)->group(function () {
        Route::get('/live-chat', 'studentLiveChat')->name('student.live_chat');
        Route::get('/chat-list', 'studentChatList')->name('livechat.student_chat_list');

    });

    Route::controller(MessageController::class)->group(function () {
        Route::get('/live-chat/{id}', 'studentChat')->name('student_livechat.chat');
        Route::post('/live-chat/store/{id}', 'studentStore')->name('student_livechat.store');
    });
});
// student live chat

// instructor live chat
Route::prefix('instructor')->middleware(['instructor', 'auth', 'verified'])->group(function () {
    Route::controller(LiveChatController::class)->group(function () {
        Route::get('/live-chat', 'instructorLiveChat')->name('instructor.live_chat');
        Route::get('/chat-list', 'instructorChatList')->name('livechat.instructor_chat_list');

    });

    Route::controller(MessageController::class)->group(function () {
        Route::get('/live-chat/{id}', 'instructorChat')->name('instructor_livechat.chat');
        Route::post('/live-chat/store/{id}', 'instructorStore')->name('instructor_livechat.store');
    });
});
Route::prefix('live-chat')->middleware(['auth'])->group(function () {
    Route::controller(MessageController::class)->group(function () {
        Route::get('message-read/{id}', 'messageRead');
    });
});
// instructor live chat
