<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <title><?php echo $__env->yieldContent('title'); ?></title>
    <link rel="icon" type="image/x-icon" href="<?php echo e(@globalAsset(setting('favicon'), '40X40.webp')); ?>">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">

    <input type="hidden" name="url" id="url" value="<?php echo e(url('')); ?>">
    <!-- Delete alert text-->
    <input type="hidden" name="alert_title" id="alert_title" value="<?php echo e(___('common.are_you_sure')); ?>">
    <input type="hidden" name="alert_subtitle" id="alert_subtitle"
        value="<?php echo e(___('common.you_wont_be_able_to_revert_this')); ?>">
    <input type="hidden" name="alert_yes_btn" id="alert_yes_btn" value="<?php echo e(___('common.yes_delete_it')); ?>">
    <input type="hidden" name="alert_cancel_btn" id="alert_cancel_btn" value="<?php echo e(___('common.Cancel')); ?>">

    <meta name="keywords"
        content="admin, admin dashboard, admin template, backend, bootstrap, crm, laravel, laravel admin, web application">
    <meta name="description" content="<?php echo e(setting('application_name')); ?>">
    <?php if(findDirectionOfLang() == 'rtl'): ?>
        <link rel="stylesheet" href="<?php echo e(global_asset('backend')); ?>/assets/css/bootstrap.rtl.min.css">
    <?php else: ?>
        <link rel="stylesheet" href="<?php echo e(global_asset('backend')); ?>/assets/css/bootstrap.min.css">
    <?php endif; ?>

    <!-- metis menu for sidebar  -->
    <link rel="stylesheet" href="<?php echo e(global_asset('backend')); ?>/assets/css/metisMenu.min.css">
    
    <link rel="stylesheet" href="<?php echo e(global_asset('backend')); ?>/assets/css/apexcharts.min.css">
    <!-- jvectormap css -->
    <link rel="stylesheet" href="<?php echo e(global_asset('backend/vendors/jvectormap/css/jquery-jvectormap-1.2.2.css')); ?>">
    
    <link rel="stylesheet" href="<?php echo e(global_asset('backend')); ?>/assets/css/icon-fonts.css">
    <!-- All Plugin  -->
    <link rel="stylesheet" href="<?php echo e(global_asset('backend')); ?>/assets/css/plugin.css">

    <link href="<?php echo e(global_asset('backend')); ?>/vendors/summernote/summernote-lite.min.css" rel="stylesheet">

    
    <link rel="stylesheet" href="<?php echo e(global_asset('backend')); ?>/assets/css/daterangepicker.css">
    

    <!-- Custom CSS  start -->
    <link rel="stylesheet" href="<?php echo e(global_asset('backend')); ?>/assets/css/style.css">
    <link rel="stylesheet" href="<?php echo e(global_asset('backend')); ?>/assets/css/style2.css">
    <link rel="stylesheet" href="<?php echo e(global_asset('backend')); ?>/assets/css/custom.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.css">


    <?php echo $__env->yieldContent('css'); ?>
    <?php echo $__env->yieldPushContent('css'); ?>

</head>

<body class="<?php echo e(findDirectionOfLang()); ?> default-theme" dir="<?php echo e(@findDirectionOfLang()); ?>">

    <div id="layout-wrapper">
        <!-- start header -->
        <?php echo $__env->make('backend.partials.header', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
        <!-- end header -->

        <!-- start sidebar -->
        <?php echo $__env->make('backend.partials.sidebar', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
        <!-- end sidebar -->

        <main class="main-content ph-24 ph-lg-32 pt-100 mt-4">
            <!-- start main content -->
            <?php echo $__env->yieldContent('content'); ?>
            <!-- end main content -->

            <!-- start footer -->
            <?php echo $__env->make('backend.partials.footer', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
            <!-- end footer -->
        </main>
    </div>

    
    <script src="<?php echo e(global_asset('backend')); ?>/assets/js/theme.js"></script>
    <script src="<?php echo e(global_asset('backend')); ?>/assets/js/popper.min.js"></script>
    <script src="<?php echo e(global_asset('backend')); ?>/assets/js/bootstrap.min.js"></script>
    <script src="<?php echo e(global_asset('backend')); ?>/assets/js/jquery-3.6.0.min.js"></script>

    <?php if(findDirectionOfLang() == 'rtl'): ?>
        <script src="<?php echo e(global_asset('backend')); ?>/assets/js/__dir.js"></script>
    <?php endif; ?>

    <script src="<?php echo e(global_asset('backend')); ?>/assets/js/semantic.min.js"></script>
    <!-- Metis menu for sidebar  -->
    <script src="<?php echo e(global_asset('backend')); ?>/assets/js/metisMenu.min.js"></script>
    <!-- jvectormap js -->
    <script src="<?php echo e(global_asset('backend/vendors/jvectormap/js/jquery-jvectormap-1.2.2.min.js')); ?>"></script>
    <script src="<?php echo e(global_asset('backend/vendors/jvectormap/js/jquery-jvectormap-us-merc-en.js')); ?>"></script>
    
    <script src="<?php echo e(global_asset('backend')); ?>/vendors/apexchart/js/apexcharts.min.js"></script>
    <script src="<?php echo e(global_asset('backend')); ?>/vendors/chartjs/js/chart.min.js"></script>
    <script src="<?php echo e(global_asset('backend')); ?>/assets/js/ot-charts.js"></script>
    <script src="<?php echo e(global_asset('backend')); ?>/assets/js/datepicker.min.js"></script>
    
    <script src="<?php echo e(global_asset('backend')); ?>/assets/js/plugin.js"></script>
    <!-- Vendor JS end  -->
    <script src="<?php echo e(global_asset('backend')); ?>/assets/js/main.js"></script>
    
    <script src="<?php echo e(global_asset('backend')); ?>/assets/js/fees-master.js"></script>
    <script src="<?php echo e(global_asset('backend')); ?>/assets/js/custom.js"></script>


    <script src="<?php echo e(global_asset('backend')); ?>/vendors/summernote/summernote-lite.min.js"></script>
    <script src="<?php echo e(global_asset('backend')); ?>/assets/js/daterangepicker.min.js"></script>
    <script src="<?php echo e(global_asset('backend')); ?>/assets/js/fullcalendar.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.js"></script>



    
    <?php echo $__env->make('backend.partials.alert-message', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
    
    <?php echo $__env->yieldPushContent('script'); ?>

    <?php echo $__env->make('pushnotification::script', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

    <?php if(hasModule('MultiBranch')): ?>
        <script>
            $(document).ready(function() {
                $('#branchId').on('change', function() {
                    let selectedValue = $(this).val();

                    if (selectedValue) {
                        $.ajax({
                            url: '<?php echo e(route('switch-branch')); ?>',
                            type: 'GET',
                            data: {
                                branch_id: selectedValue
                            },
                            success: function(response) {
                                window.location.reload();
                            },
                            error: function(xhr, status, error) {
                                window.location.reload();
                            }
                        });
                    } else {
                        $('#output').text('Please select a valid option.');
                    }
                });
            });
        </script>
    <?php endif; ?>

</body>

</html>
<?php /**PATH /Users/mohebhawari/Sites/newschool/resources/views/backend/master.blade.php ENDPATH**/ ?>