<?php $__env->startSection('title'); ?>
    <?php echo e(@$data['title']); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <div class="page-content">

        
        <div class="page-header">
            <div class="row">
                <div class="col-sm-6">
                    <h4 class="bradecrumb-title mb-1"><?php echo e($data['title']); ?></h1>
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item"><a href="<?php echo e(route('dashboard')); ?>"><?php echo e(___('common.home')); ?></a></li>
                            <li class="breadcrumb-item"><?php echo e($data['title']); ?></li>
                        </ol>
                </div>
            </div>
        </div>
        

        <!--  table content start -->
        <div class="table-content table-basic mt-20">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h4 class="mb-0"><?php echo e($data['title']); ?></h4>
                    <?php if(hasPermission('homework_create')): ?>
                        <a href="<?php echo e(route('notice-board.create')); ?>" class="btn btn-lg ot-btn-primary">
                            <span><i class="fa-solid fa-plus"></i> </span>
                            <span class=""><?php echo e(___('common.add')); ?></span>
                        </a>
                    <?php endif; ?>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-bordered role-table">
                            <thead class="thead">
                                <tr>
                                    <th class="serial"><?php echo e(___('common.sr_no')); ?></th>
                                    <th class="serial"><?php echo e(___('common.title')); ?></th>
                                    <th class="purchase"><?php echo e(___('common.Department')); ?></th>
                                    <th class="serial"><?php echo e(___('common.Accessbility')); ?></th>
                                    <th class="serial"><?php echo e(___('common.Visibility')); ?></th>
                                    <th class="purchase"><?php echo e(___('common.date')); ?></th>
                                    <th class="purchase"><?php echo e(___('common.publish_date')); ?></th>
                                    <th class="purchase"><?php echo e(___('account.description')); ?></th>
                                    <th class="purchase"><?php echo e(___('common.attachment')); ?></th>
                                    <th class="purchase"><?php echo e(___('common.status')); ?></th>
                                    <?php if(hasPermission('homework_update') || hasPermission('homework_delete')): ?>
                                        <th class="action"><?php echo e(___('common.action')); ?></th>
                                    <?php endif; ?>
                                </tr>
                            </thead>
                            <tbody class="tbody">
                                <?php $__empty_1 = true; $__currentLoopData = $data['notice-boards'] ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                    <tr id="row_<?php echo e($row->id); ?>">
                                        <td class="serial"><?php echo e(++$key); ?></td>
                                        <td><?php echo e($row->title); ?> <?php echo e($row->id); ?></td>
                                        <td><?php echo e(@$row->department->name); ?> </td>
                                        <td>
                                            <?php if($row->student): ?>
                                                <?php echo e($row->student->full_name); ?> - <?php echo e($row->class->name); ?>

                                                (<?php echo e($row->section->name); ?>)
                                            <?php elseif($row->class && $row->section): ?>
                                                <?php echo e(@$row->class->name); ?> (<?php echo e(@$row->section->name); ?>) -
                                                <?php echo e(___('common.All Students')); ?>

                                            <?php elseif($row->class): ?>
                                                <?php echo e($row->class->name); ?> - <?php echo e(___('common.All Students')); ?>

                                            <?php endif; ?>
                                        </td>
                                        <td><?php echo e($row->visible_role_names ? $row->visible_role_names : ___('common.To All')); ?>

                                        </td>
                                        <td><?php echo e(date('d-m-Y', strtotime(@$row->date))); ?></td>

                                        <td><?php echo e(date('d-m-Y H:i a', strtotime(@$row->publish_date))); ?></td>
                                        <td><?php echo \Illuminate\Support\Str::limit(strip_tags(@$row->description), 40); ?></td>

                                        <td>
                                            <a class="btn btn-lg ot-btn-primary radius_30px small_add_btn"
                                                href="<?php echo e(@globalAsset($row->attachmentFile->path, '100X100.webp')); ?>"
                                                target="_blank">
                                                <i class="fa-solid fa-eye"></i>
                                            </a>
                                        </td>
                                        <td>
                                            <?php if($row->status == App\Enums\Status::ACTIVE): ?>
                                                <span class="badge-basic-success-text"><?php echo e(___('common.active')); ?></span>
                                            <?php else: ?>
                                                <span class="badge-basic-danger-text"><?php echo e(___('common.inactive')); ?></span>
                                            <?php endif; ?>
                                        </td>
                                        <?php if(hasPermission('homework_update') || hasPermission('homework_delete')): ?>
                                            <td class="action">
                                                <div class="dropdown dropdown-action">
                                                    <button type="button" class="btn-dropdown" data-bs-toggle="dropdown"
                                                        aria-expanded="false">
                                                        <i class="fa-solid fa-ellipsis"></i>
                                                    </button>
                                                    <ul class="dropdown-menu dropdown-menu-end ">
                                                        <?php if(hasPermission('homework_update')): ?>
                                                            <li>
                                                                <a class="dropdown-item"
                                                                    href="<?php echo e(route('notice-board.edit', $row->id)); ?>"><span
                                                                        class="icon mr-8"><i
                                                                            class="fa-solid fa-pen-to-square"></i></span>
                                                                    <?php echo e(___('common.edit')); ?></a>
                                                            </li>
                                                        <?php endif; ?>
                                                        <?php if(hasPermission('homework_update')): ?>
                                                            <li>
                                                                <a class="dropdown-item"
                                                                    href="<?php echo e(route('notice-board.translate', $row->id)); ?>"><span
                                                                        class="icon mr-8"><i
                                                                            class="fa-solid fa-globe"></i></span>
                                                                    <?php echo e(___('common.translate')); ?></a>
                                                            </li>
                                                        <?php endif; ?>
                                                        <?php if(hasPermission('homework_delete')): ?>
                                                            <li>
                                                                <a class="dropdown-item" href="javascript:void(0);"
                                                                    onclick="delete_row('communication/notice-board/delete', <?php echo e($row->id); ?>)">
                                                                    <span class="icon mr-8"><i
                                                                            class="fa-solid fa-trash-can"></i></span>
                                                                    <span><?php echo e(___('common.delete')); ?></span>
                                                                </a>
                                                            </li>
                                                        <?php endif; ?>
                                                    </ul>
                                                </div>
                                            </td>
                                        <?php endif; ?>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                    <tr>
                                        <td colspan="100%" class="text-center gray-color">
                                            <img src="<?php echo e(asset('images/no_data.svg')); ?>" alt="" class="mb-primary"
                                                width="100">
                                            <p class="mb-0 text-center"><?php echo e(___('common.no_data_available')); ?></p>
                                            <p class="mb-0 text-center text-secondary font-size-90">
                                                <?php echo e(___('common.please_add_new_entity_regarding_this_table')); ?></p>
                                        </td>
                                    </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                    <!--  table end -->
                    <!--  pagination start -->

                    <div class="ot-pagination pagination-content d-flex justify-content-end align-content-center py-3">
                        <nav aria-label="Page navigation example">
                            <ul class="pagination justify-content-between">
                                <?php echo $data['notice-boards']->appends(\Request::capture()->except('page'))->links(); ?>

                            </ul>
                        </nav>
                    </div>

                    <!--  pagination end -->
                </div>
            </div>
        </div>
        <!--  table content end -->

    </div>


<?php $__env->stopSection(); ?>

<?php $__env->startPush('script'); ?>
    <?php echo $__env->make('backend.partials.delete-ajax', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('backend.master', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Users/mohebhawari/Sites/newschool/resources/views/backend/communication/notice-board/index.blade.php ENDPATH**/ ?>