<?php $__env->startSection('title'); ?>
    <?php echo e(@$data['title']); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <div class="page-content">

        
        <div class="page-header">
            <div class="row">
                <div class="col-sm-6">
                    <h4 class="bradecrumb-title mb-1"><?php echo e($data['title']); ?></h4>
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item"><a href="<?php echo e(route('dashboard')); ?>"><?php echo e(___('common.home')); ?></a></li>
                            <li class="breadcrumb-item" aria-current="page"><a
                                    href="<?php echo e(route('student.index')); ?>"><?php echo e(___('student_info.student_list')); ?></a>
                            </li>
                            <li class="breadcrumb-item active" aria-current="page"><?php echo e(___('common.add_new')); ?></li>
                        </ol>
                </div>
            </div>
        </div>
        
        <div class="card ot-card">
            <div class="card-header d-flex justify-content-between align-items-center">
                <h4 class="mb-0"> </h4>
                <?php if(hasPermission('student_create')): ?>
                    <a href="<?php echo e(route('student.import')); ?>" class="btn btn-lg ot-btn-primary">
                        <span><i class="fa-solid fa-plus"></i> </span>
                        <span class=""><?php echo e(___('common.Import')); ?></span>
                    </a>
                <?php endif; ?>
            </div>


            <div class="card-body">
                <form action="<?php echo e(route('student.store')); ?>" enctype="multipart/form-data" method="post" id="visitForm">
                    <?php echo csrf_field(); ?>
                    <div class="row mb-3">
                        <div class="col-lg-12">
                            <div class="row">
                                <div class="col-md-3 mb-3">
                                    <label for="exampleDataList" class="form-label "><?php echo e(___('student_info.admission_no')); ?>

                                        <span class="fillable">*</span></label>
                                    <input class="form-control ot-input <?php $__errorArgs = ['admission_no'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                        type="number" name="admission_no" list="datalistOptions" id="exampleDataList"
                                        placeholder="<?php echo e(___('student_info.enter_admission_no')); ?>"
                                        value="<?php echo e(old('admission_no')); ?>">
                                    <?php $__errorArgs = ['admission_no'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <div id="validationServer04Feedback" class="invalid-feedback">
                                            <?php echo e($message); ?>

                                        </div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                                <div class="col-md-3 mb-3">
                                    <label for="exampleDataList" class="form-label "><?php echo e(___('student_info.roll_no')); ?>

                                        <span class="fillable">*</span></label>
                                    <input class="form-control ot-input <?php $__errorArgs = ['roll_no'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                        name="roll_no" list="datalistOptions" id="exampleDataList" type="number"
                                        placeholder="<?php echo e(___('student_info.enter_roll_no')); ?>"
                                        value="<?php echo e(old('roll_no')); ?>">
                                    <?php $__errorArgs = ['roll_no'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <div id="validationServer04Feedback" class="invalid-feedback">
                                            <?php echo e($message); ?>

                                        </div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                                <div class="col-md-3 mb-3">
                                    <label for="exampleDataList" class="form-label "><?php echo e(___('student_info.first_name')); ?>

                                        <span class="fillable">*</span></label>
                                    <input class="form-control ot-input <?php $__errorArgs = ['first_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                        name="first_name" list="datalistOptions" id="exampleDataList"
                                        placeholder="<?php echo e(___('student_info.enter_first_name')); ?>"
                                        value="<?php echo e(old('first_name')); ?>">
                                    <?php $__errorArgs = ['first_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <div id="validationServer04Feedback" class="invalid-feedback">
                                            <?php echo e($message); ?>

                                        </div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                                <div class="col-md-3 mb-3">
                                    <label for="exampleDataList" class="form-label "><?php echo e(___('student_info.last_name')); ?>

                                        <span class="fillable">*</span></label>
                                    <input class="form-control ot-input <?php $__errorArgs = ['last_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                        name="last_name" list="datalistOptions" id="exampleDataList"
                                        placeholder="<?php echo e(___('student_info.enter_last_name')); ?>"
                                        value="<?php echo e(old('last_name')); ?>">
                                    <?php $__errorArgs = ['last_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <div id="validationServer04Feedback" class="invalid-feedback">
                                            <?php echo e($message); ?>

                                        </div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                                <div class="col-md-3 mb-3">
                                    <label class="form-label"><?php echo e(___('frontend.Arabic_Name')); ?> </label>
                                    <input name="student_ar_name" placeholder="<?php echo e(___('frontend.Arabic_Name')); ?>"
                                        class="email form-control ot-input mb_30" type="text"
                                        value="<?php echo e(old('student_ar_name')); ?>">
                                </div>

                                <div class="col-md-3 mb-3">
                                    <label for="exampleDataList" class="form-label "><?php echo e(___('student_info.mobile')); ?> <span
                                            class="fillable"></span></label>
                                    <input class="form-control ot-input <?php $__errorArgs = ['mobile'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                        name="mobile" list="datalistOptions" id="exampleDataList" type="number"
                                        placeholder="<?php echo e(___('student_info.enter_mobile')); ?>" value="<?php echo e(old('mobile')); ?>">
                                    <?php $__errorArgs = ['mobile'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <div id="validationServer04Feedback" class="invalid-feedback">
                                            <?php echo e($message); ?>

                                        </div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                                <div class="col-md-3 mb-3">
                                    <label for="exampleDataList" class="form-label "><?php echo e(___('common.email')); ?> <span
                                            class="fillable"></span></label>
                                    <input class="form-control ot-input <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                        name="email" list="datalistOptions" id="exampleDataList" type="email"
                                        placeholder="<?php echo e(___('student_info.enter_email')); ?>" value="<?php echo e(old('email')); ?>">
                                    <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <div id="validationServer04Feedback" class="invalid-feedback">
                                            <?php echo e($message); ?>

                                        </div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                                <div class="col-md-3 mb-3">
                                    <label class="form-label"><?php echo e(___('frontend.Username')); ?> </label>
                                    <input name="username" placeholder="<?php echo e(___('frontend.Username')); ?>"
                                        class="username form-control ot-input mb_30" type="text"
                                        value="<?php echo e(old('username')); ?>">
                                    <?php if($errors->has('username')): ?>
                                        <div class="error text-danger"><?php echo e($errors->first('username')); ?></div>
                                    <?php endif; ?>
                                </div>

                                <div class="col-md-3 mb-3">
                                    <label for="departmentId" class="form-label"><?php echo e(___('common.Department')); ?>

                                        <span class="fillable">*</span></label>
                                    <select
                                        class="nice-select niceSelect bordered_style wide <?php $__errorArgs = ['department_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                        name="department_id" id="departmentId">
                                        <option value=""><?php echo e(___('student_info.select Department')); ?></option>
                                        <?php $__currentLoopData = $data['departments'] ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $id => $name): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option <?php echo e(old('department_id') == $id ? 'selected' : ''); ?> value="<?php echo e($id); ?>"><?php echo e($name); ?> </option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>

                                    <?php $__errorArgs = ['department_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <div id="validationServer04Feedback" class="invalid-feedback">
                                            <?php echo e($message); ?>

                                        </div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>

                                <input type="hidden" id="siblings_discount" name="siblings_discount" value="0">
                                <div class="col-md-3">

                                    <label for="validationServer04" class="form-label"><?php echo e(___('student_info.class')); ?>

                                        <span class="fillable">*</span></label>
                                    <select id="getSections"
                                        class="nice-select niceSelect bordered_style wide <?php $__errorArgs = ['class'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                        name="class" id="validationServer04"
                                        aria-describedby="validationServer04Feedback">
                                        <option value=""><?php echo e(___('student_info.select_class')); ?></option>
                                        <?php $__currentLoopData = $data['classes']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option <?php echo e(old('class') == $item->id ? 'selected' : ''); ?>

                                                value="<?php echo e($item->class->id); ?>"><?php echo e($item->class->name); ?>

                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </option>
                                    </select>

                                    <?php $__errorArgs = ['class'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <div id="validationServer04Feedback" class="invalid-feedback">
                                            <?php echo e($message); ?>

                                        </div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>

                                </div>

                                <div class="col-md-3">
                                    <label for="validationServer04" class="form-label"><?php echo e(___('student_info.section')); ?>

                                        <span class="fillable">*</span></label>
                                    <select id="getSections"
                                        class="nice-select sections niceSelect bordered_style wide <?php $__errorArgs = ['section'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                        name="section" id="validationServer04"
                                        aria-describedby="validationServer04Feedback">
                                        <option value=""><?php echo e(___('student_info.select_section')); ?></option>
                                    </select>
                                    <?php $__errorArgs = ['section'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <div id="validationServer04Feedback" class="invalid-feedback">
                                            <?php echo e($message); ?>

                                        </div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>

                                <div class="col-md-3">

                                    <label for="validationServer04" class="form-label"><?php echo e(___('student_info.shift')); ?>

                                        <span class="fillable"></span></label>
                                    <select
                                        class="nice-select niceSelect bordered_style wide <?php $__errorArgs = ['shift'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                        name="shift" id="validationServer04"
                                        aria-describedby="validationServer04Feedback">
                                        <option value=""><?php echo e(___('student_info.select_shift')); ?></option>
                                        <?php $__currentLoopData = $data['shifts']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option <?php echo e(old('shift') == $item->id ? 'selected' : ''); ?>

                                                value="<?php echo e($item->id); ?>"><?php echo e($item->name); ?>

                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>

                                    <?php $__errorArgs = ['status'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <div id="validationServer04Feedback" class="invalid-feedback">
                                            <?php echo e($message); ?>

                                        </div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>

                                </div>
                                <div class="col-md-3 mb-3">
                                    <label for="exampleDataList" class="form-label "><?php echo e(___('common.date_of_birth')); ?>

                                        <span class="fillable">*</span></label>
                                    <input type="date"
                                        class="form-control ot-input <?php $__errorArgs = ['date_of_birth'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                        name="date_of_birth" list="datalistOptions" id="exampleDataList"
                                        placeholder="<?php echo e(___('common.date_of_birth')); ?>"
                                        value="<?php echo e(old('date_of_birth')); ?>">
                                    <?php $__errorArgs = ['date_of_birth'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <div id="validationServer04Feedback" class="invalid-feedback">
                                            <?php echo e($message); ?>

                                        </div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>

                                <div class="col-md-3">

                                    <label for="validationServer04" class="form-label"><?php echo e(___('student_info.religion')); ?>

                                        <span class="fillable"></span></label>
                                    <select
                                        class="nice-select niceSelect bordered_style wide <?php $__errorArgs = ['religion'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                        name="religion" id="validationServer04"
                                        aria-describedby="validationServer04Feedback">
                                        <option value=""><?php echo e(___('student_info.select_religion')); ?></option>
                                        <?php $__currentLoopData = $data['religions']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option <?php echo e(old('religion') == $item->id ? 'selected' : ''); ?>

                                                value="<?php echo e($item->id); ?>"><?php echo e($item->name); ?>

                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>

                                    <?php $__errorArgs = ['religion'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <div id="validationServer04Feedback" class="invalid-feedback">
                                            <?php echo e($message); ?>

                                        </div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>

                                </div>
                                <div class="col-md-3">

                                    <label for="validationServer04" class="form-label"><?php echo e(___('common.gender')); ?> <span
                                            class="fillable"></span></label>
                                    <select
                                        class="nice-select niceSelect bordered_style wide <?php $__errorArgs = ['gender'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                        name="gender" id="validationServer04"
                                        aria-describedby="validationServer04Feedback">
                                        <option value=""><?php echo e(___('student_info.select_gender')); ?></option>
                                        <?php $__currentLoopData = $data['genders']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option <?php echo e(old('gender') == $item->id ? 'selected' : ''); ?>

                                                value="<?php echo e($item->id); ?>"><?php echo e($item->name); ?>

                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>

                                    <?php $__errorArgs = ['gender'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <div id="validationServer04Feedback" class="invalid-feedback">
                                            <?php echo e($message); ?>

                                        </div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>

                                </div>
                                <div class="col-md-3">

                                    <label for="validationServer04" class="form-label"><?php echo e(___('common.category')); ?> <span
                                            class="fillable"></span></label>
                                    <select
                                        class="nice-select niceSelect bordered_style wide <?php $__errorArgs = ['category'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                        name="category" id="validationServer04"
                                        aria-describedby="validationServer04Feedback">
                                        <option value=""><?php echo e(___('student_info.select_category')); ?></option>
                                        <?php $__currentLoopData = $data['categories']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option <?php echo e(old('category') == $item->id ? 'selected' : ''); ?>

                                                value="<?php echo e($item->id); ?>"><?php echo e($item->name); ?>

                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>

                                    <?php $__errorArgs = ['category'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <div id="validationServer04Feedback" class="invalid-feedback">
                                            <?php echo e($message); ?>

                                        </div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>

                                </div>
                                <div class="col-md-3">

                                    <label for="validationServer04" class="form-label"><?php echo e(___('student_info.blood')); ?>

                                        <span class="fillable"></span></label>
                                    <select
                                        class="nice-select niceSelect bordered_style wide <?php $__errorArgs = ['blood'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                        name="blood" id="validationServer04"
                                        aria-describedby="validationServer04Feedback">
                                        <option value=""><?php echo e(___('student_info.select_blood')); ?></option>
                                        <?php $__currentLoopData = $data['bloods']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option <?php echo e(old('blood') == $item->id ? 'selected' : ''); ?>

                                                value="<?php echo e($item->id); ?>"><?php echo e($item->name); ?>

                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>

                                    <?php $__errorArgs = ['blood'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <div id="validationServer04Feedback" class="invalid-feedback">
                                            <?php echo e($message); ?>

                                        </div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>

                                </div>
                                <div class="col-md-3 mb-3">
                                    <label for="exampleDataList"
                                        class="form-label "><?php echo e(___('student_info.admission_date')); ?> <span
                                            class="fillable">*</span></label>
                                    <input type="date"
                                        class="form-control ot-input <?php $__errorArgs = ['admission_date'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                        name="admission_date" list="datalistOptions" id="exampleDataList"
                                        placeholder="<?php echo e(___('student_info.admission_date')); ?>"
                                        value="<?php echo e(old('admission_date')); ?>">
                                    <?php $__errorArgs = ['admission_date'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <div id="validationServer04Feedback" class="invalid-feedback">
                                            <?php echo e($message); ?>

                                        </div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                                <div class="col-md-3">
                                    <label for="exampleDataList" class="form-label "><?php echo e(___('common.image')); ?>

                                        <?php echo e(___('common.(100 x 100 px)')); ?><span class="fillable"></span></label>
                                    <div class="ot_fileUploader left-side mb-3">
                                        <input class="form-control" type="text"
                                            placeholder="<?php echo e(___('common.image')); ?>" readonly="" id="placeholder">
                                        <button class="primary-btn-small-input" type="button">
                                            <label class="btn btn-lg ot-btn-primary"
                                                for="fileBrouse"><?php echo e(___('common.browse')); ?></label>
                                            <input type="file" class="d-none form-control" name="image"
                                                id="fileBrouse" accept="image/*">
                                        </button>
                                    </div>
                                </div>
                                <div class="col-md-3 parent mb-3">

                                    <label for="validationServer04"
                                        class="form-label"><?php echo e(___('student_info.select_parent')); ?>

                                        <span class="fillable">*</span></label>
                                    <select
                                        class="parent nice-select niceSelect bordered_style wide <?php $__errorArgs = ['parent'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                        name="parent" id="validationServer04"
                                        aria-describedby="validationServer04Feedback">
                                        <option value=""><?php echo e(___('student_info.select_parent')); ?></option>
                                        <?php $__currentLoopData = $data['parentGuardians']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $parentGuardian): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option <?php echo e(old('parent') == $parentGuardian->id ? 'selected' : ''); ?>

                                                value="<?php echo e($parentGuardian->id); ?>">
                                                <?php echo e($parentGuardian->guardian_name); ?>

                                            </option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>

                                    <?php $__errorArgs = ['parent'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <div id="validationServer04Feedback" class="invalid-feedback">
                                            <?php echo e($message); ?>

                                        </div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>

                                </div>

                                <div>
                                    <h5 id="discount-alert" class="text-success text-center"></h5>
                                </div>
                                <div class="row mb-3" id="child-info"></div>


                                <div class="col-md-3 mb-3">
                                    <label class="form-label"
                                        for="#"><?php echo e(___('frontend.attend_school_previously')); ?> </label>
                                    <div class="input-check-radio academic-section mt-3">
                                        <div class="form-check">
                                            <input class="form-check-input" type="checkbox" name="previous_school"
                                                value="1" id="previous_school">
                                            <label class="form-check-label ps-2 pe-5"
                                                for="previous_school"><?php echo e(___('common.Yes')); ?></label>
                                        </div>
                                    </div>
                                </div>

                                <div class="col-md-6 d-none mb-3" id="previous_school_info">
                                    <label class="form-label"
                                        for="#"><?php echo e(___('frontend.previous_school_information')); ?> </label>
                                    <textarea class="form-control" rows="2" name="previous_school_info"></textarea>

                                </div>

                                <div class="col-xl-3 d-none mb-3" id="previous_school_doc">
                                    <label for="exampleDataList"
                                        class="form-label"><?php echo e(___('frontend.previous_school_documents')); ?><span
                                            class="fillable"></span>

                                    </label>

                                    <div class="ot_fileUploader left-side mb-3">
                                        <input class="form-control" type="text"
                                            placeholder="<?php echo e(___('common.image')); ?>" readonly="" id="placeholder1">
                                        <button class="primary-btn-small-input" type="button">
                                            <label class="btn btn-lg ot-btn-primary"
                                                for="fileBrouse1"><?php echo e(___('common.browse')); ?></label>
                                            <input type="file" class="d-none form-control"
                                                name="previous_school_image" id="fileBrouse1" accept="image/*">
                                        </button>
                                    </div>

                                </div>
                                <div class="col-md-3 mb-3">
                                    <label class="form-label"><?php echo e(___('frontend.Place_Of_Birth')); ?> </label>
                                    <input name="place_of_birth" placeholder="<?php echo e(___('frontend.Place_Of_Birth')); ?>"
                                        class="email form-control ot-input mb_30" type="text">
                                </div>
                                <div class="col-md-3 mb-3">
                                    <label class="form-label"><?php echo e(___('frontend.Student_Nationality')); ?>

                                    </label>
                                    <input name="nationality" placeholder="<?php echo e(___('frontend.Student_Nationality')); ?>"
                                        class="email form-control ot-input mb_30" type="text">
                                </div>
                                <div class="col-md-3 mb-3">
                                    <label class="form-label"><?php echo e(___('frontend.CPR_Number')); ?> </label>
                                    <input name="cpr_no" placeholder="<?php echo e(___('frontend.CPR_Number')); ?>"
                                        class="email form-control ot-input mb_30" type="text">
                                </div>
                                <div class="col-md-3 mb-3">
                                    <label class="form-label"><?php echo e(___('frontend.Student_Sponken_Language_At_Home')); ?>

                                    </label>
                                    <input name="spoken_lang_at_home"
                                        placeholder="<?php echo e(___('frontend.Student_Sponken_Language_At_Home')); ?>"
                                        class="email form-control ot-input mb_30" type="text">
                                </div>
                                <div class="col-md-3 mb-3">
                                    <label class="form-label"><?php echo e(___('frontend.Residance_Address')); ?> </label>
                                    <input name="residance_address"
                                        placeholder="<?php echo e(___('frontend.Residance_Address')); ?>"
                                        class="email form-control ot-input mb_30" type="text">
                                </div>




                                <div class="col-md-3">

                                    <label for="validationServer04" class="form-label"><?php echo e(___('common.status')); ?> <span
                                            class="fillable">*</span></label>
                                    <select
                                        class="nice-select niceSelect bordered_style wide <?php $__errorArgs = ['status'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                        name="status" id="validationServer04"
                                        aria-describedby="validationServer04Feedback">
                                        <option <?php echo e(old('status') ? 'selected' : ''); ?>

                                            value="<?php echo e(App\Enums\Status::ACTIVE); ?>"><?php echo e(___('common.active')); ?>

                                        </option>
                                        <option <?php echo e(old('status') ? 'selected' : ''); ?>

                                            value="<?php echo e(App\Enums\Status::INACTIVE); ?>"><?php echo e(___('common.inactive')); ?>

                                        </option>
                                    </select>

                                    <?php $__errorArgs = ['status'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <div id="validationServer04Feedback" class="invalid-feedback">
                                            <?php echo e($message); ?>

                                        </div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>

                                </div>
                                <div class="col-md-3 mb-3">
                                    <label class="form-label"><?php echo e(___('frontend.ID_Certificate')); ?> </label>
                                    <input name="student_id_certificate"
                                        placeholder="<?php echo e(___('frontend.ID_Certificate')); ?>"
                                        class="email form-control ot-input mb_30" type="text"
                                        value="<?php echo e(old('student_id_certificate')); ?>">
                                </div>
                                <div class="col-md-3 mb-3">
                                    <label class="form-label"><?php echo e(___('frontend.Emergency_Contact')); ?> </label>
                                    <input name="emergency_contact"
                                        placeholder="<?php echo e(___('frontend.Emergency_Contact')); ?>"
                                        class="email form-control ot-input mb_30" type="text"
                                        value="<?php echo e(old('emergency_contact')); ?>">
                                </div>



                                <div class="col-md-3 mb-3">
                                    <label for="HealthStatus" class="form-label "><?php echo e(___('common.Health Status')); ?></label>
                                    <input type="text"
                                        class="form-control ot-input <?php $__errorArgs = ['health_status'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                        name="health_status" id="HealthStatus"
                                        placeholder="<?php echo e(___('common.Health Status')); ?>"
                                        value="<?php echo e(old('health_status')); ?>">
                                    <?php $__errorArgs = ['health_status'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <div id="validationServer04Feedback" class="invalid-feedback">
                                            <?php echo e($message); ?>

                                        </div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>

                                <div class="col-md-3 mb-3">
                                    <label for="rank_in_family" class="form-label "><?php echo e(___('common.Rank in family')); ?></label>
                                    <input type="number"
                                        class="form-control ot-input <?php $__errorArgs = ['rank_in_family'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                        name="rank_in_family" id="rank_in_family"
                                        placeholder="<?php echo e(___('common.1st child, 2nd child ...')); ?>"
                                        value="<?php echo e(old('rank_in_family', 1)); ?>">
                                    <?php $__errorArgs = ['rank_in_family'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <div id="validationServer04Feedback" class="invalid-feedback">
                                            <?php echo e($message); ?>

                                        </div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>

                                <div class="col-md-3 mb-3">
                                    <label for="siblings" class="form-label "><?php echo e(___('common.Number of brothers/sisters')); ?></label>
                                    <input type="number"
                                        class="form-control ot-input <?php $__errorArgs = ['siblings'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                        name="siblings" id="siblings"
                                        placeholder="<?php echo e(___('common.Number of brothers/sisters')); ?>"
                                        value="<?php echo e(old('siblings', 0)); ?>">
                                    <?php $__errorArgs = ['siblings'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <div id="validationServer04Feedback" class="invalid-feedback">
                                            <?php echo e($message); ?>

                                        </div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>

                                <div class="col-md-3">
                                    <div class="form-group mb-3">
                                        <label class="form-label" for="password"
                                            class="form-label"><?php echo e(___('frontend.Password')); ?>

                                        </label> <br>
                                        <input type="radio" name="password_type" value="default" id=""
                                            checked> <span class="mr-4"><?php echo e(___('frontend.Default Password')); ?>

                                            (123456)</span>
                                        <input type="radio" name="password_type" value="custom" id="">
                                        <span><?php echo e(___('frontend.Custom Password')); ?></span>
                                    </div>
                                </div>


                                <div id="SelectionDiv" class="col-md-3">
                                    <div class="form-group mb-3">
                                        <label class="form-label" for="password"
                                            class="form-label"><?php echo e(___('frontend.Password')); ?>

                                        </label>
                                        <input type="text" name="password"
                                            placeholder="<?php echo e(___('frontend.Password')); ?>" autocomplete="off"
                                            class="form-control ot-form-control ot-input" value="<?php echo e(old('password')); ?>"
                                            id="password">
                                        <?php if($errors->has('password')): ?>
                                            <div class="error text-danger"><?php echo e($errors->first('password')); ?></div>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </div>

                            <div class="row mt-24">
                                <div class="col-md-12">
                                    <div class="d-flex align-items-center gap-4 flex-wrap">
                                        <h3 class="m-0 flex-fill fs-4">
                                            <?php echo e(___('student_info.upload_documents')); ?>

                                        </h3>
                                        <button type="button"
                                            class="btn btn-lg ot-btn-primary radius_30px small_add_btn addNewDocument"
                                            onclick="addNewDocument()">
                                            <span><i class="fa-solid fa-plus"></i> </span>
                                            <?php echo e(___('common.add')); ?></button>
                                        <input type="hidden" name="counter" id="counter" value="0">
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-12">
                                    <div class="table-responsive">
                                        <table class="table school_borderLess_table table_border_hide2"
                                            id="student-document">
                                            <thead>
                                                <tr>
                                                    <th scope="col"><?php echo e(___('common.name')); ?> <span
                                                            class="text-danger"></span>
                                                        <?php if($errors->any()): ?>
                                                            <?php if($errors->has('document_names.*')): ?>
                                                                <span class="text-danger"><?php echo e('the fields are required'); ?>

                                                            <?php endif; ?>
                                                        <?php endif; ?>
                                                    </th>
                                                    <th scope="col">
                                                        <?php echo e(___('common.document')); ?>

                                                        <span class="text-danger"></span>
                                                        <?php if($errors->any()): ?>
                                                            <?php if($errors->has('document_files.*')): ?>
                                                                <span class="text-danger"><?php echo e('The fields are required'); ?>

                                                            <?php endif; ?>
                                                        <?php endif; ?>
                                                    </th>
                                                    <th scope="col">
                                                        <?php echo e(___('common.action')); ?>

                                                    </th>
                                                </tr>
                                            </thead>
                                            <tbody>

                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-12 mt-24">
                                    <div class="text-end">
                                        <button class="btn btn-lg ot-btn-primary"><span><i class="fa-solid fa-save"></i>
                                            </span><?php echo e(___('common.submit')); ?></button>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('script'); ?>
    <script>
        $(document).ready(function() {
            var fileInp1 = document.getElementById("fileBrouse1");
            if (fileInp1) {
                fileInp1.addEventListener("change", showFileName);

                function showFileName(event) {
                    var fileInp = event.srcElement;
                    var fileName = fileInp.files[0].name;
                    document.getElementById("placeholder1").placeholder = fileName;
                }
            }

            function checkCheckboxState() {
                var isChecked = $('#previous_school').prop('checked');
                if (isChecked) {
                    $('#previous_school_info').removeClass('d-none');
                    $('#previous_school_doc').removeClass('d-none');
                } else {
                    $('#previous_school_info').addClass('d-none');
                    $('#previous_school_doc').addClass('d-none');
                }
            }

            $('#previous_school').change(checkCheckboxState);
            checkCheckboxState();

            // Initially hide the role selection div
            $('#SelectionDiv').hide();

            // Attach an event listener to the radio buttons
            $('input[name="password_type"]').on('change', function() {
                if ($(this).val() === 'custom') {

                    // If the 'custom' radio button is selected, show the role selection div
                    $('#SelectionDiv').show();
                } else {
                    // If the 'default' radio button is selected or other value, hide the  selection div
                    $('#SelectionDiv').hide();
                }
            });


        });

         $(document).ready(function () {
            $('.parent').on('change', function () {
                var parentId = $(this).val();
                if (parentId) {
                    $.ajax({
                        url: '/student/get-children/' + parentId,
                        type: 'GET',
                        dataType: 'json',
                        success: function (response) {
                            console.log(response)
                            if (response.status === 'success') {
                                let html = '';
                                if (response.data.siblingsCount > 0) {
                                    html += `
                                        <div class="card mb-4">
                                            <div class="card-header mt-3">
                                                <h5 class="mb-0 text-center">Siblings Information</h5>
                                            </div>
                                            <div class="card-body">
                                                <div class="row">
                                    `;

                                    $.each(response.data.children, function (i, child) {
                                        html += `
                                        <div class="col-md-4 mb-3">
                                            <div class="card h-100 shadow-sm">
                                                <div class="card-body p-3">
                                                    <h5 class="card-title">${child.full_name}</h5>
                                                    <p class="mb-1"><strong>Admission No:</strong> ${child.admission_no}</p>
                                                    <p class="mb-1"><strong>Roll No:</strong> ${child.roll_no}</p>
                                                    <p class="mb-0"> <strong>Class: </strong> ${child.session_class_student.class.name}</p>
                                                    <p class="mb-1"><strong>DOB:</strong> ${child.dob}</p>
                                                    <p class="mb-1"><strong>Email:</strong> ${child.email}</p>
                                                    <p class="mb-1"><strong>Mobile:</strong> ${child.mobile}</p>
                                                    <p class="mb-0"><strong>Admission Date:</strong> ${child.admission_date}</p>
                                                </div>
                                            </div>
                                        </div>
                                    `;
                                    });

                                    html += `
                </div>
            </div>
        </div>
    `;

                                    if (response.data.isEligible){
                                        $('#discount-alert').text('A ' + response.data.siblingDiscount + '% sibling discount will be applied to all assigned fees for this student.');
                                        $('#siblings_discount').val(response.data.isEligible ? 1 : 0);
                                        toastr.success('Student is eligible for sibling discount');
                                    }
                                }

                                $('#child-info').html(html);

                            }
                        }
                    });
                } else {
                    $('#child-info').html('');
                }
            });
        });

    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('backend.master', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Users/mohebhawari/Sites/newschool/resources/views/backend/student-info/student/create.blade.php ENDPATH**/ ?>