<?php $__env->startSection('title'); ?>
    <?php echo e(@$data['title']); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <div class="page-content">

        
        <div class="page-header">
            <div class="row">
                <div class="col-sm-6">
                    <h4 class="bradecrumb-title mb-1"><?php echo e($data['title']); ?></h1>
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a href="<?php echo e(route('dashboard')); ?>"><?php echo e(___('common.home')); ?></a></li>
                        <li class="breadcrumb-item"><?php echo e($data['title']); ?></li>
                    </ol>
                </div>
            </div>
        </div>
        
        
        <!--  table content start -->
        <div class="table-content table-basic mt-20">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h4 class="mb-0"><?php echo e($data['title']); ?></h4>
                    <?php if(hasPermission('id_card_create')): ?>
                        <a href="<?php echo e(route('idcard.create')); ?>" class="btn btn-lg ot-btn-primary">
                            <span><i class="fa-solid fa-plus"></i> </span>
                            <span class=""><?php echo e(___('common.add')); ?></span>
                        </a>
                    <?php endif; ?>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-bordered role-table">
                            <thead class="thead">
                                <tr>
                                    <th class="serial"><?php echo e(___('common.sr_no')); ?></th>
                                    <th class="purchase"><?php echo e(___('common.title')); ?> </th>
                                    <th class="purchase"><?php echo e(___('common.expired_date')); ?></th>
                                    <th class="purchase"><?php echo e(___('common.visibility')); ?></th>
                                    <th class="purchase"><?php echo e(___('common.preview')); ?></th>
                                    <?php if(hasPermission('id_card_update') || hasPermission('id_card_delete')): ?>
                                        <th class="action"><?php echo e(___('common.action')); ?></th>
                                    <?php endif; ?>
                                </tr>
                            </thead>
                            <tbody class="tbody">
                                <?php $__empty_1 = true; $__currentLoopData = $data['id_cards'] ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <tr id="row_<?php echo e($row->id); ?>">
                                    <td class="serial"><?php echo e(++$key); ?></td>
                                    <td><?php echo e($row->title); ?></td>
                                    <td><?php echo e($row->expired_date); ?></td>
           
                                    <td>
                                        <div class="id-card-visibility">
                                        <?php echo e(___('common.student_name')); ?>: 
                                       
                                            <input class="toggle-checkbox" type="checkbox" name="section_name" <?php echo e($row->student_name == true ? 'checked':''); ?>  id="toggle1">
                                            <label class="slider-btn" for="toggle1"></label>
                                        </div>
                                        <br>
                                        <div class="id-card-visibility">
                                        <?php echo e(___('common.admission_no')); ?>: 
                                       
                                        <input class="toggle-checkbox" type="checkbox" name="section_name" <?php echo e($row->admission_no == true ? 'checked':''); ?>  id="toggle2">
                                            <label class="slider-btn" for="toggle2"></label>
                                        </div>
                                        <br>

                                        <div class="id-card-visibility">
                                        
                                        <?php echo e(___('common.roll_no')); ?>: 
                                        <input class="toggle-checkbox" type="checkbox" name="section_name" <?php echo e($row->roll_no == true ? 'checked':''); ?>  id="toggle3">
                                            <label class="slider-btn" for="toggle3"></label>
                                        </div>
                                        <br>
                                        <div class="id-card-visibility">
                                        <?php echo e(___('common.class_name')); ?>: 
                                        <input class="toggle-checkbox" type="checkbox" name="section_name" <?php echo e($row->class_name == true ? 'checked':''); ?> disabled id="toggle4">
                                            <label class="slider-btn" for="toggle4"></label>
                                        </div>
                                        <br> 
                                        <div class="id-card-visibility">   
                                        <?php echo e(___('common.section_name')); ?>: 
                                        <input class="toggle-checkbox" type="checkbox" name="section_name" <?php echo e($row->section_name == true ? 'checked':''); ?> disabled id="toggle5">
                                            <label class="slider-btn" for="toggle5"></label>
                                        </div>
                                        <br>  
                                        <div class="id-card-visibility">  
                                        <?php echo e(___('common.blood_group')); ?>: 
                                        <input class="toggle-checkbox" type="checkbox" name="section_name" <?php echo e($row->blood_group == true ? 'checked':''); ?> disabled id="toggle6">
                                            <label class="slider-btn" for="toggle6"></label>
                                        </div>
                                        <br>    
                                        <div class="id-card-visibility">  
                                        <?php echo e(___('common.date_of_birth')); ?>: 
                                        <input class="toggle-checkbox" type="checkbox" name="dob" <?php echo e($row->dob == true ? 'checked':''); ?> disabled id="toggle7">
                                            <label class="slider-btn" for="toggle7"></label>
                                        </div>
                                        <br>    
                                    </td>
                                    <td>
                                        <a class="btn btn-sm ot-btn-primary"
                                                            href="#" data-bs-toggle="modal"
                                                            data-bs-target="#openIdCardPreviewModal" onclick="openIdCardPreviewModal(<?php echo e($row->id); ?>)"><span
                                                                class="icon mr-8"><i
                                                                    class="fa-solid fa-eye"></i></span>
                                                            <?php echo e(___('common.preview')); ?></a>
                                    </td>
                                    <?php if(hasPermission('id_card_update') || hasPermission('id_card_delete')): ?>
                                        <td class="action">
                                            <div class="dropdown dropdown-action">
                                                <button type="button" class="btn-dropdown" data-bs-toggle="dropdown"
                                                    aria-expanded="false">
                                                    <i class="fa-solid fa-ellipsis"></i>
                                                </button>
                                                <ul class="dropdown-menu dropdown-menu-end ">
                                                    <?php if(hasPermission('id_card_update')): ?>
                                                        <li>
                                                            <a class="dropdown-item"
                                                                href="<?php echo e(route('idcard.edit', $row->id)); ?>"><span
                                                                    class="icon mr-8"><i
                                                                        class="fa-solid fa-pen-to-square"></i></span>
                                                                <?php echo e(___('common.edit')); ?></a>
                                                        </li>
                                                    <?php endif; ?>
                                                    <?php if(hasPermission('id_card_delete')): ?>
                                                        <li>
                                                            <a class="dropdown-item" href="javascript:void(0);"
                                                                onclick="delete_row('idcard/delete', <?php echo e($row->id); ?>)">
                                                                <span class="icon mr-8"><i
                                                                        class="fa-solid fa-trash-can"></i></span>
                                                                <span><?php echo e(___('common.delete')); ?></span>
                                                            </a>
                                                        </li>
                                                    <?php endif; ?>
                                                </ul>
                                            </div>
                                        </td>
                                    <?php endif; ?>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <tr>
                                    <td colspan="100%" class="text-center gray-color">
                                        <img src="<?php echo e(asset('images/no_data.svg')); ?>" alt="" class="mb-primary" width="100">
                                        <p class="mb-0 text-center"><?php echo e(___('common.no_data_available')); ?></p>
                                        <p class="mb-0 text-center text-secondary font-size-90">
                                            <?php echo e(___('common.please_add_new_entity_regarding_this_table')); ?></p>
                                    </td>
                                </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                    <!--  table end -->
                    <!--  pagination start -->

                        <div class="ot-pagination pagination-content d-flex justify-content-end align-content-center py-3">
                            <nav aria-label="Page navigation example">
                                <ul class="pagination justify-content-between">
                                    <?php echo $data['id_cards']->appends(\Request::capture()->except('page'))->links(); ?>

                                </ul>
                            </nav>
                        </div>

                    <!--  pagination end -->
                </div>
            </div>
        </div>
        <!--  table content end -->

    </div>


    <div id="view-modal">
        <div class="modal fade" id="openIdCardPreviewModal" tabindex="-1" aria-labelledby="modalWidth"
            aria-hidden="true">
            <div class="modal-dialog modal-lg">
                <div class="modal-content" id="modalWidth">
                    <div class="modal-header modal-header-image">
                        <h5 class="modal-title" id="modalLabel2">
                            <?php echo e(___('common.Preview')); ?>

                        </h5>
                        <button type="button" class="m-0 btn-close d-flex justify-content-center align-items-center"
                            data-bs-dismiss="modal" aria-label="Close"><i class="fa fa-times text-white" aria-hidden="true"></i></button>
                    </div>
                    
                        <div class="modal-body p-5">
                            
                        </div>
                </div>
                
            </div>
        </div>
    </div>


<?php $__env->stopSection(); ?>

<?php $__env->startPush('script'); ?>
    <?php echo $__env->make('backend.partials.delete-ajax', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('backend.master', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Users/mohebhawari/Sites/newschool/resources/views/backend/id-card/index.blade.php ENDPATH**/ ?>