<?php $__env->startSection('title'); ?>
    <?php echo e(@$data['title']); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <div class="page-content">

        
        <div class="page-header">
            <div class="row">
                <div class="col-sm-6">
                    <h4 class="bradecrumb-title mb-1"><?php echo e($data['title']); ?></h1>
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a href="<?php echo e(route('dashboard')); ?>"><?php echo e(___('common.home')); ?></a></li>
                        <li class="breadcrumb-item"><?php echo e($data['title']); ?></li>
                    </ol>
                </div>
            </div>
        </div>
        
        
        <!--  table content start -->
        <div class="table-content table-basic mt-20">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h4 class="mb-0"><?php echo e($data['title']); ?></h4>
                    <?php if(hasPermission('sms_mail_send')): ?>
                        <a href="<?php echo e(route('smsmail.create')); ?>" class="btn btn-lg ot-btn-primary">
                            <span><i class="fa-solid fa-plus"></i> </span>
                            <span class=""><?php echo e(___('common.add')); ?></span>
                        </a>
                    <?php endif; ?>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-bordered role-table sms-mail">
                            <thead class="thead">
                                <tr>
                                    <th class="serial"><?php echo e(___('common.sr_no')); ?></th>
                                    <th class="serial"><?php echo e(___('common.title')); ?></th>
                                    <th class="purchase"><?php echo e(___('academic.type')); ?> </th>
                                    <th class="purchase"><?php echo e(___('common.user_type')); ?></th>
                                    <th class="purchase"><?php echo e(___('account.description')); ?></th>
                                </tr>
                            </thead>
                            <tbody class="tbody">
                                <?php $__empty_1 = true; $__currentLoopData = $data['smsmail'] ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <tr id="row_<?php echo e($row->id); ?>">
                                    <td class="serial"><?php echo e(++$key); ?></td>
                                    <td><?php echo e($row->title); ?></td>
                                    <td><?php echo e($row->type); ?></td>

                                    <td>
                                        <?php echo e($row->user_type_value); ?>

                                    </td>

                                    <td>
                                        <?php if($row->type == App\Enums\TemplateType::SMS): ?> 

                                       <?php echo e(@$row->sms_description); ?>


                                        <?php else: ?> 
                                        
                                        <?php echo @$row->mail_description; ?>


                                        <?php echo e(___('common.attachment')); ?>: <a class="btn btn-sm ot-btn-primary" href="<?php echo e(@globalAsset($row->attachmentFile->path, '100X100.webp')); ?>" target="_blank"><i class="fa-solid fa-eye"></i>

                                        <?php endif; ?>
                                    </td>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <tr>
                                    <td colspan="100%" class="text-center gray-color">
                                        <img src="<?php echo e(asset('images/no_data.svg')); ?>" alt="" class="mb-primary" width="100">
                                        <p class="mb-0 text-center"><?php echo e(___('common.no_data_available')); ?></p>
                                        <p class="mb-0 text-center text-secondary font-size-90">
                                            <?php echo e(___('common.please_add_new_entity_regarding_this_table')); ?></p>
                                    </td>
                                </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                    <!--  table end -->
                    <!--  pagination start -->

                        <div class="ot-pagination pagination-content d-flex justify-content-end align-content-center py-3">
                            <nav aria-label="Page navigation example">
                                <ul class="pagination justify-content-between">
                                    <?php echo $data['smsmail']->appends(\Request::capture()->except('page'))->links(); ?>

                                </ul>
                            </nav>
                        </div>

                    <!--  pagination end -->
                </div>
            </div>
        </div>
        <!--  table content end -->

    </div>


<?php $__env->stopSection(); ?>

<?php $__env->startPush('script'); ?>
    <?php echo $__env->make('backend.partials.delete-ajax', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
    <script src="<?php echo e(global_asset('backend')); ?>/assets/js/__sms_mail.js"></script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('backend.master', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Users/mohebhawari/Sites/newschool/resources/views/backend/communication/smsmail/index.blade.php ENDPATH**/ ?>