<?php $__env->startSection('title', @$title); ?>
<?php $__env->startPush('css'); ?>
    <link rel="stylesheet" href="<?php echo e(asset('modules/livechat/css/app.css')); ?>">
<?php $__env->stopPush(); ?>
<?php $__env->startSection('content'); ?>
    <audio id="message_sound">
        <source src="<?php echo e(asset('modules/livechat/file/sound.mp3')); ?>" type="audio/mpeg">
    </audio>
    <!-- Chat box Area two s t a r t-->
    <div class="chat-box-area card card-body border-0">
        <div class="row">
            <div class="col-xxl-3 col-xl-4 col-lg-6 col-md-5 col-sm-5">
                <!-- Chat left side-bar -->
                <div class="chat-left-sidebar">
                    <!-- Admin Profile -->
                    <div class="chat-admin">
                        <!-- Profile -->
                        <div class="profile-wrap">
                            <div class="user-img">
                                <img src="<?php echo e(@globalAsset(auth()->user()->student->upload->path, '40X40.webp')); ?>"
                                    alt="img" class="img-cover">
                            </div>
                            <div class="user-chat-caption">
                                <h5 class="user-name"><?php echo e(auth()->user()->name); ?></h5>
                                <p class="chat-status"><?php echo e(___('live_chat.Active')); ?></p>
                            </div>
                        </div>
                    </div>
                    <!-- My Listings -->
                    <div class="chat-list-wrapper ">
                        <div class="search-chat mb-20">
                            <input class="form-control ot-input" type="text" id="chat_search" onkeyup="searchChat()"
                                placeholder="<?php echo e(___('live_chat.Search')); ?>">
                        </div>
                        <div class="chat-list" data-url="<?php echo e(route('livechat.admin_chat_list')); ?>">
                        </div>
                    </div>

                </div>
            </div>
            <input type="text" hidden id="receiver_id" value="<?php echo e(auth()->id()); ?>">
            <input type="text" hidden id="app_key" value="<?php echo e(env('PUSHER_APP_KEY')); ?>">
            <input type="text" hidden id="cluster" value="<?php echo e(env('PUSHER_APP_CLUSTER')); ?>">
            <input type="text" hidden id="chat_active_user" value="<?php echo e(decryptFunction(request('id'))); ?>">
            <div class="col-xxl-9 col-xl-8 col-lg-6 col-md-7 col-sm-7">
                <div class="chat-body">
                    <!-- curren-chat-user -->
                    <div class="current-chat-user">
                        <div class="chat-cap">
                            <div class="user-img">
                                <img src="<?php echo e(@globalAsset($user->upload->path)); ?>" alt="img" class="img-cover">
                            </div>
                            <div class="user-chat-caption" id="current_user" data-id="<?php echo e(encryptFunction(@$user->id)); ?>">
                                <h4 class="mb-0"><a href="javascript:;" class="user-name"><?php echo e(@$user->name); ?></a></h4>
                                <small>Active</small>
                            </div>
                        </div>
                    </div>
                    <!-- End-of Show product -->
                    <!-- MessageBox -->
                    <div class="chatBox-message">
                        <div class="chatShow">
                            <!-- userMessage -->

                            <?php $__currentLoopData = $messages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $message): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <!-- adminMessage -->
                                <?php if(@$message->sender->id == auth()->user()->id): ?>
                                    <div class="single-chat adminMessage" id="message-<?php echo e($message->id); ?>">
                                        <div class="chatText">
                                            <div class="chatImg">
                                                <img src="<?php echo e(@globalAsset(@$message->sender->upload->path, '40X40.webp')); ?>"
                                                    alt="img" class="img-cover">
                                            </div>
                                            <div class="chatCaption">
                                                <p class="chatPera"> <?php echo e($message->message); ?></p>
                                                <small class="time"> <?php echo e(\Carbon\Carbon::parse($message->created_at)->diffForHumans()); ?></small>
                                            </div>
                                        </div>
                                    </div>
                                <?php else: ?>
                                    <div class="single-chat userMessage" id="message-<?php echo e($message->id); ?>">
                                        <div class="chatText">
                                            <div class="chatImg">
                                                <img src="<?php echo e(@globalAsset(@$message->receiver->upload->path, '40X40.webp')); ?>"
                                                    alt="img" class="img-cover">
                                            </div>
                                            <div class="chatCaption">
                                                <p class="chatPera"><?php echo e($message->message); ?></p>
                                                <small class="time"> <?php echo e(\Carbon\Carbon::parse($message->created_at)->diffForHumans()); ?></small>
                                            </div>
                                        </div>
                                    </div>
                                <?php endif; ?>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                        <!-- chatSend input box-->
                        <div class="chatSend-wrapper">
                            <div class="sendMessage">
                                <input class="input" type="text" id="chat_text" name="chat"
                                    placeholder="Write your chat...">
                                <div class="btn-wrapper form-icon">
                                    <button class="btn-rounded2" type="submit" name="submit" id="message_sent"
                                        data-url="<?php echo e(route('admin_livechat.store', encryptFunction(@$user->id))); ?>"><?php echo e(___('live_chat.Send')); ?></button>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- End-of Chat Box Area -->

<?php $__env->stopSection(); ?>

<?php $__env->startPush('script'); ?>
    <script src="https://js.pusher.com/7.0/pusher.min.js"></script>
    <script src="<?php echo e(asset('modules/livechat/js/app.js')); ?>"></script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('backend.master', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Users/mohebhawari/Sites/newschool/Modules/LiveChat/Resources/views/message/admin.blade.php ENDPATH**/ ?>