<?php $__env->startSection('title'); ?>
    <?php echo e(@$data['title']); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>

    <div class="page-content">

        
        <div class="page-header">
            <div class="row">
                <div class="col-sm-6">
                    <h4 class="bradecrumb-title mb-1"><?php echo e($data['title']); ?></h1>
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a href="<?php echo e(route('dashboard')); ?>"><?php echo e(___('common.home')); ?></a></li>
                        <li class="breadcrumb-item"><?php echo e($data['title']); ?></li>
                    </ol>
                </div>
            </div>
        </div>
        

        <!--  table content start -->
        <div class="table-content table-basic mt-20">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h4 class="mb-0"><?php echo e(___('language.languages')); ?></h4>

                        <a href="<?php echo e(route('languages.create')); ?>" class="btn btn-lg ot-btn-primary">
                            <span><i class="fa-solid fa-plus"></i> </span>
                            <span class=""><?php echo e(___('common.add')); ?></span>
                        </a>

                </div>
                <div class="card-body ot-card">
                    <div class="table-responsive">
                        <table class="table table-bordered ot-table-bg language-table">
                            <thead class="thead">
                                <tr>
                                    <th class="serial"><?php echo e(___('common.sr_no')); ?></th>
                                    <th class="purchase"><?php echo e(___('common.name')); ?></th>
                                    <th class="purchase"><?php echo e(___('language.code')); ?></th>
                                    <th class="purchase"><?php echo e(___('language.icon')); ?></th>
                                    <th class="action"><?php echo e(___('common.action')); ?></th>
                                </tr>
                            </thead>
                            <tbody class="tbody">
                                <?php $__empty_1 = true; $__currentLoopData = $data['languages']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <tr id="row_<?php echo e($row->id); ?>">
                                    <td class="serial"><?php echo e(++$key); ?></td>
                                    <td> <?php echo e($row->name); ?> <?php echo e($row->summernote); ?></td>
                                    <td><?php echo e($row->code); ?></td>
                                    <td><i class="<?php echo e($row->icon_class); ?> "></i></td>

                                        <td class="action">
                                            <div class="dropdown dropdown-action">
                                                <button type="button" class="btn-dropdown" data-bs-toggle="dropdown"
                                                    aria-expanded="false">
                                                    <i class="fa-solid fa-ellipsis"></i>
                                                </button>
                                                <ul class="dropdown-menu dropdown-menu-end">

                                                        <li>
                                                            <a class="dropdown-item"
                                                                href="<?php echo e(route('languages.edit', $row->id)); ?>"><span
                                                                    class="icon mr-8"><i
                                                                        class="fa-solid fa-pen-to-square"></i></span>
                                                                <span><?php echo e(___('common.edit')); ?></span></a>
                                                        </li>

                                                    <?php if($row->code != 'en'): ?>

                                                            <li>
                                                                <a class="dropdown-item" href="javascript:void(0);"
                                                                    onclick="delete_row('languages/delete', <?php echo e($row->id); ?>)">
                                                                    <span class="icon mr-8"><i
                                                                            class="fa-solid fa-trash-can"></i></span>
                                                                    <span><?php echo e(___('common.delete')); ?></span>
                                                                </a>
                                                            </li>
                                                        <?php endif; ?>


                                                            <a class="dropdown-item"
                                                                href="<?php echo e(route('languages.edit.terms', $row->id)); ?>"><span
                                                                    class="icon mr-8"><i
                                                                        class="fa-solid fa-pen-to-square"></i></span>
                                                                <span><?php echo e(___('language.edit_terms')); ?></span></a>
                                                        </li>

                                                </ul>
                                            </div>
                                        </td>
                                    
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <tr>
                                    <td colspan="100%" class="text-center gray-color">
                                        <img src="<?php echo e(asset('images/no_data.svg')); ?>" alt="" class="mb-primary" width="100">
                                        <p class="mb-0 text-center"><?php echo e(___('common.no_data_available')); ?></p>
                                        <p class="mb-0 text-center text-secondary font-size-90">
                                            <?php echo e(___('common.please_add_new_entity_regarding_this_table')); ?></p>
                                    </td>
                                </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                    <!--  table end -->
                    <!--  pagination start -->
                    <?php if(count($data['languages']) > 10): ?>
                        <div class="ot-pagination pagination-content d-flex justify-content-end align-content-center py-3">
                            <nav aria-label="Page navigation example">
                                <ul class="pagination">
                                    <?php echo $data['languages']->links(); ?>

                                </ul>
                            </nav>
                        </div>
                    <?php endif; ?>
                    <!--  pagination end -->
                </div>
            </div>
        </div>
        <!--  table content end -->
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('script'); ?>
    <?php echo $__env->make('backend.partials.delete-ajax', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('backend.master', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Users/mohebhawari/Sites/newschool/resources/views/backend/languages/index.blade.php ENDPATH**/ ?>