<?php

namespace Database\Seeders\WebsiteSetup;

use App\Models\PageTranslate;
use App\Models\WebsiteSetup\Page;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class PageSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $pages = [
            [
                'name' => 'Privacy Policy',
                'slug' => 'privacy_policy',
                'content' => '<div class="elementor-element elementor-element-790b948d elementor-widget elementor-widget-text-editor" data-id="790b948d" data-element_type="widget" data-widget_type="text-editor.default" style="--flex-direction: initial; --flex-wrap: initial; --justify-content: initial; --align-items: initial; --align-content: initial; --gap: initial; --flex-basis: initial; --flex-grow: initial; --flex-shrink: initial; --order: initial; --align-self: initial; flex-basis: var(--flex-basis); flex-grow: var(--flex-grow); flex-shrink: var(--flex-shrink); order: var(--order); align-self: var(--align-self); flex-direction: var(--flex-direction); flex-wrap: var(--flex-wrap); justify-content: var(--justify-content); align-items: var(--align-items); align-content: var(--align-content); gap: var(--gap); position: relative; --swiper-theme-color: #000; --swiper-navigation-size: 44px; --swiper-pagination-bullet-size: 6px; --swiper-pagination-bullet-horizontal-gap: 6px; --widgets-spacing: 20px; color: var( --e-global-color-text ); font-family: var( --e-global-typography-text-font-family ), &quot;Roboto&quot;, Sans-serif; width: 1280px; margin-bottom: 0px; z-index: 3;"><div class="elementor-widget-container" style="transition: background .3s,border .3s,border-radius .3s,box-shadow .3s,transform var(--e-transform-transition-duration,.4s); padding: 0px 0px 100px;"><h3 dir="ltr" style="line-height:1.38;margin-top:14pt;margin-bottom:4pt;"><span style="font-size:13pt;font-family:Arial,sans-serif;color:#000000;background-color:transparent;font-weight:700;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;">Privacy Policy for Onest Schooled Management System</span></h3><p dir="ltr" style="line-height:1.38;margin-top:12pt;margin-bottom:12pt;"><span style="font-size:11pt;font-family:Arial,sans-serif;color:#000000;background-color:transparent;font-weight:700;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;">Privacy Policy</span><span style="font-size:11pt;font-family:Arial,sans-serif;color:#000000;background-color:transparent;font-weight:700;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;"><br></span><span style="font-size:11pt;font-family:Arial,sans-serif;color:#000000;background-color:transparent;font-weight:400;font-style:italic;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;">Last updated: 22 November, 2025</span></p><p dir="ltr" style="line-height:1.38;margin-top:12pt;margin-bottom:12pt;"><span style="font-size:11pt;font-family:Arial,sans-serif;color:#000000;background-color:transparent;font-weight:700;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;">Introduction</span><span style="font-size:11pt;font-family:Arial,sans-serif;color:#000000;background-color:transparent;font-weight:700;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;"><br></span><span style="font-size:11pt;font-family:Arial,sans-serif;color:#000000;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;">Onest Schooled Management System values your privacy. This policy explains how we collect, use, and safeguard your data when you use our app.</span></p><p dir="ltr" style="line-height:1.38;margin-top:12pt;margin-bottom:12pt;"><span style="font-size:11pt;font-family:Arial,sans-serif;color:#000000;background-color:transparent;font-weight:700;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;">1. Information We Collect</span></p><ul style="margin-top:0;margin-bottom:0;padding-inline-start:48px;"><li dir="ltr" style="list-style-type:disc;font-size:11pt;font-family:Arial,sans-serif;color:#000000;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;" aria-level="1"><p dir="ltr" style="line-height:1.38;margin-top:12pt;margin-bottom:0pt;" role="presentation"><span style="font-size:11pt;font-family:Arial,sans-serif;color:#000000;background-color:transparent;font-weight:700;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;">User Data</span><span style="font-size:11pt;font-family:Arial,sans-serif;color:#000000;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;">: Names, email addresses, contact details, roles (student, teacher, parent, or admin).</span></p></li><li dir="ltr" style="list-style-type:disc;font-size:11pt;font-family:Arial,sans-serif;color:#000000;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;" aria-level="1"><p dir="ltr" style="line-height:1.38;margin-top:0pt;margin-bottom:0pt;" role="presentation"><span style="font-size:11pt;font-family:Arial,sans-serif;color:#000000;background-color:transparent;font-weight:700;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;">Operational Data</span><span style="font-size:11pt;font-family:Arial,sans-serif;color:#000000;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;">: Attendance, grades, homework, library usage, and fee transactions.</span></p></li><li dir="ltr" style="list-style-type:disc;font-size:11pt;font-family:Arial,sans-serif;color:#000000;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;" aria-level="1"><p dir="ltr" style="line-height:1.38;margin-top:0pt;margin-bottom:12pt;" role="presentation"><span style="font-size:11pt;font-family:Arial,sans-serif;color:#000000;background-color:transparent;font-weight:700;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;">Device Data</span><span style="font-size:11pt;font-family:Arial,sans-serif;color:#000000;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;">: Device type, operating system, and logs for app functionality.</span></p></li></ul><p dir="ltr" style="line-height:1.38;margin-top:12pt;margin-bottom:12pt;"><span style="font-size:11pt;font-family:Arial,sans-serif;color:#000000;background-color:transparent;font-weight:700;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;">2. How We Use Your Information</span></p><ul style="margin-top:0;margin-bottom:0;padding-inline-start:48px;"><li dir="ltr" style="list-style-type:disc;font-size:11pt;font-family:Arial,sans-serif;color:#000000;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;" aria-level="1"><p dir="ltr" style="line-height:1.38;margin-top:12pt;margin-bottom:0pt;" role="presentation"><span style="font-size:11pt;font-family:Arial,sans-serif;color:#000000;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;">To facilitate administrative operations, such as admission, fee collection, attendance, and academic management.</span></p></li><li dir="ltr" style="list-style-type:disc;font-size:11pt;font-family:Arial,sans-serif;color:#000000;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;" aria-level="1"><p dir="ltr" style="line-height:1.38;margin-top:0pt;margin-bottom:0pt;" role="presentation"><span style="font-size:11pt;font-family:Arial,sans-serif;color:#000000;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;">To provide personalized dashboards for students, teachers, and parents.</span></p></li><li dir="ltr" style="list-style-type:disc;font-size:11pt;font-family:Arial,sans-serif;color:#000000;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;" aria-level="1"><p dir="ltr" style="line-height:1.38;margin-top:0pt;margin-bottom:12pt;" role="presentation"><span style="font-size:11pt;font-family:Arial,sans-serif;color:#000000;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;">To enhance user experience and app security.</span></p></li></ul><p dir="ltr" style="line-height:1.38;margin-top:12pt;margin-bottom:12pt;"><span style="font-size:11pt;font-family:Arial,sans-serif;color:#000000;background-color:transparent;font-weight:700;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;">3. Sharing Your Information</span><span style="font-size:11pt;font-family:Arial,sans-serif;color:#000000;background-color:transparent;font-weight:700;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;"><br></span><span style="font-size:11pt;font-family:Arial,sans-serif;color:#000000;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;">We only share data with:</span></p><ul style="margin-top:0;margin-bottom:0;padding-inline-start:48px;"><li dir="ltr" style="list-style-type:disc;font-size:11pt;font-family:Arial,sans-serif;color:#000000;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;" aria-level="1"><p dir="ltr" style="line-height:1.38;margin-top:12pt;margin-bottom:0pt;" role="presentation"><span style="font-size:11pt;font-family:Arial,sans-serif;color:#000000;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;">School administrators for operational purposes.</span></p></li><li dir="ltr" style="list-style-type:disc;font-size:11pt;font-family:Arial,sans-serif;color:#000000;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;" aria-level="1"><p dir="ltr" style="line-height:1.38;margin-top:0pt;margin-bottom:12pt;" role="presentation"><span style="font-size:11pt;font-family:Arial,sans-serif;color:#000000;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;">Authorities when required by law.</span></p></li></ul><p dir="ltr" style="line-height:1.38;margin-top:12pt;margin-bottom:12pt;"><span style="font-size:11pt;font-family:Arial,sans-serif;color:#000000;background-color:transparent;font-weight:700;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;">4. Data Security</span><span style="font-size:11pt;font-family:Arial,sans-serif;color:#000000;background-color:transparent;font-weight:700;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;"><br></span><span style="font-size:11pt;font-family:Arial,sans-serif;color:#000000;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;">We implement industry-standard security measures, including encryption and regular audits.</span></p><p dir="ltr" style="line-height:1.38;margin-top:12pt;margin-bottom:12pt;"><span style="font-size:11pt;font-family:Arial,sans-serif;color:#000000;background-color:transparent;font-weight:700;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;">5. Your Rights</span></p><ul style="margin-top:0;margin-bottom:0;padding-inline-start:48px;"><li dir="ltr" style="list-style-type:disc;font-size:11pt;font-family:Arial,sans-serif;color:#000000;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;" aria-level="1"><p dir="ltr" style="line-height:1.38;margin-top:12pt;margin-bottom:0pt;" role="presentation"><span style="font-size:11pt;font-family:Arial,sans-serif;color:#000000;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;">Access or modify personal data through the user portal.</span></p></li><li dir="ltr" style="list-style-type:disc;font-size:11pt;font-family:Arial,sans-serif;color:#000000;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;" aria-level="1"><p dir="ltr" style="line-height:1.38;margin-top:0pt;margin-bottom:12pt;" role="presentation"><span style="font-size:11pt;font-family:Arial,sans-serif;color:#000000;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;">Request deletion of your data by contacting support (subject to operational constraints).</span></p></li></ul><p dir="ltr" style="line-height:1.38;margin-top:12pt;margin-bottom:12pt;"><span style="font-size:11pt;font-family:Arial,sans-serif;color:#000000;background-color:transparent;font-weight:700;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;">6. Policy Updates</span><span style="font-size:11pt;font-family:Arial,sans-serif;color:#000000;background-color:transparent;font-weight:700;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;"><br></span><span style="font-size:11pt;font-family:Arial,sans-serif;color:#000000;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;">We may update this policy. Changes will be notified via email or app alerts.</span></p><p style="margin-bottom: 0.9rem;"><span id="docs-internal-guid-0452a37e-7fff-0696-3df4-c342ecd0bf24"></span></p><p dir="ltr" style="line-height:1.38;margin-top:12pt;margin-bottom:12pt;"><span style="font-size:11pt;font-family:Arial,sans-serif;color:#000000;background-color:transparent;font-weight:700;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;">Contact Us</span><span style="font-size:11pt;font-family:Arial,sans-serif;color:#000000;background-color:transparent;font-weight:700;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;"><br></span><span style="font-size:11pt;font-family:Arial,sans-serif;color:#000000;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;">For questions or concerns, reach us at sales.onesttech.com</span></p></div></div><div class="elementor-element elementor-element-4f36e2b7 elementor-widget__width-initial elementor-absolute elementor-widget elementor-widget-spacer" data-id="4f36e2b7" data-element_type="widget" data-settings="{&quot;_position&quot;:&quot;absolute&quot;}" data-widget_type="spacer.default" style="--flex-direction: initial; --flex-wrap: initial; --justify-content: initial; --align-items: initial; --align-content: initial; --gap: initial; --flex-basis: initial; --flex-grow: initial; --flex-shrink: initial; --order: initial; --align-self: initial; flex-basis: var(--flex-basis); flex-grow: var(--flex-grow); flex-shrink: var(--flex-shrink); order: var(--order); align-self: var(--align-self); flex-direction: var(--flex-direction); flex-wrap: var(--flex-wrap); justify-content: var(--justify-content); align-items: var(--align-items); align-content: var(--align-content); gap: var(--gap); position: absolute; --swiper-theme-color: #000; --swiper-navigation-size: 44px; --swiper-pagination-bullet-size: 6px; --swiper-pagination-bullet-horizontal-gap: 6px; --widgets-spacing: 20px; z-index: 1; width: var( --container-widget-width, 100vw ); margin-bottom: 0px; max-width: 100vw; --spacer-size: 100vh; --container-widget-width: 100vw; --container-widget-flex-grow: 0; top: -0.5px; right: 551px; color: rgb(51, 51, 51); font-family: -apple-system, &quot;system-ui&quot;, &quot;Segoe UI&quot;, Roboto, &quot;Helvetica Neue&quot;, Arial, &quot;Noto Sans&quot;, sans-serif, &quot;Apple Color Emoji&quot;, &quot;Segoe UI Emoji&quot;, &quot;Segoe UI Symbol&quot;, &quot;Noto Color Emoji&quot;;"><div class="elementor-widget-container" style="transition: background .3s,border .3s,border-radius .3s,box-shadow .3s,transform var(--e-transform-transition-duration,.4s); background-color: transparent; background-image: radial-gradient(rgba(44, 255, 0, 0.06) 0%, rgba(0, 0, 0, 0) 70%);"><div class="elementor-spacer"></div></div></div>',

                'menu_show' => 'footer'
            ],

            [
                'name' => 'Support Policy',
                'slug' => 'support_policy',
                'content' =>
                '<h3 dir="ltr" style="line-height:1.38;margin-top:14pt;margin-bottom:4pt;"><span style="font-size:13pt;font-family:Arial,sans-serif;color:#000000;background-color:transparent;font-weight:700;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;">Support Policy for Onest Schooled Management System</span></h3><p dir="ltr" style="line-height:1.38;margin-top:12pt;margin-bottom:12pt;"><span style="font-size:11pt;font-family:Arial,sans-serif;color:#000000;background-color:transparent;font-weight:700;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;">Support Policy</span></p><p dir="ltr" style="line-height:1.38;margin-top:12pt;margin-bottom:12pt;"><span style="font-size:11pt;font-family:Arial,sans-serif;color:#000000;background-color:transparent;font-weight:700;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;">1. Scope of Support</span><span style="font-size:11pt;font-family:Arial,sans-serif;color:#000000;background-color:transparent;font-weight:700;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;"><br></span><span style="font-size:11pt;font-family:Arial,sans-serif;color:#000000;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;">We provide assistance for:</span></p><ul style="margin-top:0;margin-bottom:0;padding-inline-start:48px;"><li dir="ltr" style="list-style-type:disc;font-size:11pt;font-family:Arial,sans-serif;color:#000000;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;" aria-level="1"><p dir="ltr" style="line-height:1.38;margin-top:12pt;margin-bottom:0pt;" role="presentation"><span style="font-size:11pt;font-family:Arial,sans-serif;color:#000000;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;">Setup and configuration.</span></p></li><li dir="ltr" style="list-style-type:disc;font-size:11pt;font-family:Arial,sans-serif;color:#000000;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;" aria-level="1"><p dir="ltr" style="line-height:1.38;margin-top:0pt;margin-bottom:0pt;" role="presentation"><span style="font-size:11pt;font-family:Arial,sans-serif;color:#000000;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;">Troubleshooting technical issues.</span></p></li><li dir="ltr" style="list-style-type:disc;font-size:11pt;font-family:Arial,sans-serif;color:#000000;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;" aria-level="1"><p dir="ltr" style="line-height:1.38;margin-top:0pt;margin-bottom:12pt;" role="presentation"><span style="font-size:11pt;font-family:Arial,sans-serif;color:#000000;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;">Feature-related queries.</span></p></li></ul><p dir="ltr" style="line-height:1.38;margin-top:12pt;margin-bottom:12pt;"><span style="font-size:11pt;font-family:Arial,sans-serif;color:#000000;background-color:transparent;font-weight:700;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;">2. Support Channels</span></p><ul style="margin-top:0;margin-bottom:0;padding-inline-start:48px;"><li dir="ltr" style="list-style-type:disc;font-size:11pt;font-family:Arial,sans-serif;color:#000000;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;" aria-level="1"><p dir="ltr" style="line-height:1.38;margin-top:12pt;margin-bottom:0pt;" role="presentation"><span style="font-size:11pt;font-family:Arial,sans-serif;color:#000000;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;">Email: [sales.onesttech.com]</span></p></li><li dir="ltr" style="list-style-type:disc;font-size:11pt;font-family:Arial,sans-serif;color:#000000;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;" aria-level="1"><p dir="ltr" style="line-height:1.38;margin-top:0pt;margin-bottom:12pt;" role="presentation"><span style="font-size:11pt;font-family:Arial,sans-serif;color:#000000;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;">Whatsapp: [+880 1959-335555]</span></p></li></ul><p dir="ltr" style="line-height:1.38;margin-top:12pt;margin-bottom:12pt;"><span style="font-size:11pt;font-family:Arial,sans-serif;color:#000000;background-color:transparent;font-weight:700;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;">3. Response Time</span></p><ul style="margin-top:0;margin-bottom:0;padding-inline-start:48px;"><li dir="ltr" style="list-style-type:disc;font-size:11pt;font-family:Arial,sans-serif;color:#000000;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;" aria-level="1"><p dir="ltr" style="line-height:1.38;margin-top:12pt;margin-bottom:0pt;" role="presentation"><span style="font-size:11pt;font-family:Arial,sans-serif;color:#000000;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;">General Queries: Response within 48 business hours.</span></p></li><li dir="ltr" style="list-style-type:disc;font-size:11pt;font-family:Arial,sans-serif;color:#000000;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;" aria-level="1"><p dir="ltr" style="line-height:1.38;margin-top:0pt;margin-bottom:12pt;" role="presentation"><span style="font-size:11pt;font-family:Arial,sans-serif;color:#000000;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;">Critical Issues (e.g., service downtime): Response within 24 hours.</span></p></li></ul><p dir="ltr" style="line-height:1.38;margin-top:12pt;margin-bottom:12pt;"><span style="font-size:11pt;font-family:Arial,sans-serif;color:#000000;background-color:transparent;font-weight:700;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;">4. Updates &amp; Maintenance</span><span style="font-size:11pt;font-family:Arial,sans-serif;color:#000000;background-color:transparent;font-weight:700;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;"><br></span><span style="font-size:11pt;font-family:Arial,sans-serif;color:#000000;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;">Regular updates are provided for feature enhancements and bug fixes. Notification will be sent before scheduled maintenance.</span></p><p><span id="docs-internal-guid-500ba9c7-7fff-1baf-821f-835a1517b432"></span></p><p dir="ltr" style="line-height:1.38;margin-top:12pt;margin-bottom:12pt;"><span style="font-size:11pt;font-family:Arial,sans-serif;color:#000000;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;">Let me know if you’d like to further customize these policies or add more details!</span></p>',

                'menu_show' => 'footer'
            ],

            [
                'name' => 'Terms & Conditions',
                'slug' => 'terms_conditions',
                'content' =>
                '<p><b>Terms and Conditions of Use for ' . setting('application_name') . ' Management Software
                        </b></p><p><b><br></b>
                                                    These Terms and Conditions govern your access to and use of the School Management Software , provided by ' . setting('application_name') . ' . By accessing or using the Software, you agree to be bound by these Terms. If you do not agree to these Terms, please refrain from accessing or using the Software.
                        </p><p><br></p><p><b>
                                                    Acceptance of Terms: </b>By accessing or using the Software, you agree to be bound by these Terms. If you do not agree to all the terms and conditions of this agreement, you must not use the Software.</p><p><br></p><p>
                        </p><p><b style="color: var(--ot-text-subtitle); background-color: transparent; font-size: var(--bs-body-font-size); text-align: var(--bs-body-text-align);">Use of the Software:</b><span style="color: var(--ot-text-subtitle); background-color: transparent; font-size: var(--bs-body-font-size); font-weight: var(--bs-body-font-weight); text-align: var(--bs-body-text-align);"> The Software is provided solely for the purpose of managing educational institutions, including but not limited to schools, colleges, and universities. You agree not to use the Software for any illegal or unauthorized purpose.</span></p><p><span style="color: var(--ot-text-subtitle); background-color: transparent; font-size: var(--bs-body-font-size); font-weight: var(--bs-body-font-weight); text-align: var(--bs-body-text-align);"><br></span></p><p><span style="color: var(--ot-text-subtitle); background-color: transparent; font-size: var(--bs-body-font-size); font-weight: var(--bs-body-font-weight); text-align: var(--bs-body-text-align);">
                        </span></p><p><span style="color: var(--ot-text-subtitle); background-color: transparent; font-size: var(--bs-body-font-size); font-weight: var(--bs-body-font-weight); text-align: var(--bs-body-text-align);"><b>User Accounts: </b></span><span style="color: var(--ot-text-subtitle); background-color: transparent; font-size: var(--bs-body-font-size); font-weight: var(--bs-body-font-weight); text-align: var(--bs-body-text-align);">You may need to create an account to access certain features of the Software. You are responsible for maintaining the confidentiality of your account credentials and for all activities that occur under your account.</span></p><p><span style="color: var(--ot-text-subtitle); background-color: transparent; font-size: var(--bs-body-font-size); font-weight: var(--bs-body-font-weight); text-align: var(--bs-body-text-align);"><br></span></p><p><span style="color: var(--ot-text-subtitle); background-color: transparent; font-size: var(--bs-body-font-size); font-weight: var(--bs-body-font-weight); text-align: var(--bs-body-text-align);"><br></span></p><p><span style="color: var(--ot-text-subtitle); background-color: transparent; font-size: var(--bs-body-font-size); text-align: var(--bs-body-text-align);"><b>

                                                    Privacy:</b></span><span style="color: var(--ot-text-subtitle); background-color: transparent; font-size: var(--bs-body-font-size); font-weight: var(--bs-body-font-weight); text-align: var(--bs-body-text-align);"> We are committed to protecting your privacy. Our Privacy Policy outlines how we collect, use, and disclose your personal information. By using the Software, you consent to the collection, use, and disclosure of your personal information as described in the Privacy Policy.</span></p><p><span style="color: var(--ot-text-subtitle); background-color: transparent; font-size: var(--bs-body-font-size); font-weight: var(--bs-body-font-weight); text-align: var(--bs-body-text-align);"><br></span></p><p><span style="color: var(--ot-text-subtitle); background-color: transparent; font-size: var(--bs-body-font-size); font-weight: var(--bs-body-font-weight); text-align: var(--bs-body-text-align);">
                        </span></p><p><span style="color: var(--ot-text-subtitle); background-color: transparent; font-size: var(--bs-body-font-size); text-align: var(--bs-body-text-align);"><b>
                                                    Intellectual Property:</b></span><span style="color: var(--ot-text-subtitle); background-color: transparent; font-size: var(--bs-body-font-size); font-weight: var(--bs-body-font-weight); text-align: var(--bs-body-text-align);"> The Software and its original content, features, and functionality are owned by ' . setting('application_name') . ' and are protected by international copyright, trademark, patent, trade secret, and other intellectual property or proprietary rights laws.</span></p><p><span style="color: var(--ot-text-subtitle); background-color: transparent; font-size: var(--bs-body-font-size); font-weight: var(--bs-body-font-weight); text-align: var(--bs-body-text-align);"><br></span></p><p><span style="color: var(--ot-text-subtitle); background-color: transparent; font-size: var(--bs-body-font-size); font-weight: var(--bs-body-font-weight); text-align: var(--bs-body-text-align);">
                        </span></p><p><span style="color: var(--ot-text-subtitle); background-color: transparent; font-size: var(--bs-body-font-size); text-align: var(--bs-body-text-align);"><b>
                                                    Limitation of Liability:</b></span><span style="color: var(--ot-text-subtitle); background-color: transparent; font-size: var(--bs-body-font-size); font-weight: var(--bs-body-font-weight); text-align: var(--bs-body-text-align);"> In no event shall
                                                    ' . setting('application_name') . ' be liable for any indirect, incidental, special, consequential, or punitive damages, including but not limited to loss of profits, data, or goodwill, arising from the use of or inability to use the Software.</span></p><p><span style="color: var(--ot-text-subtitle); background-color: transparent; font-size: var(--bs-body-font-size); font-weight: var(--bs-body-font-weight); text-align: var(--bs-body-text-align);"><br></span></p><p><span style="color: var(--ot-text-subtitle); background-color: transparent; font-size: var(--bs-body-font-size); font-weight: var(--bs-body-font-weight); text-align: var(--bs-body-text-align);">
                        </span></p><p><span style="background-color: transparent; color: var(--ot-text-subtitle); font-size: var(--bs-body-font-size); text-align: var(--bs-body-text-align);"><b>Changes to Terms:</b></span><span style="background-color: transparent; color: var(--ot-text-subtitle); font-size: var(--bs-body-font-size); font-weight: var(--bs-body-font-weight); text-align: var(--bs-body-text-align);"> We reserve the right to modify or replace these Terms at any time. If a revision is material, we will provide at least 30 days notice prior to any new terms taking effect. What constitutes a material change will be determined at our sole discretion.</span></p><p><span style="background-color: transparent; color: var(--ot-text-subtitle); font-size: var(--bs-body-font-size); font-weight: var(--bs-body-font-weight); text-align: var(--bs-body-text-align);"><br></span></p><p><span style="background-color: transparent; color: var(--ot-text-subtitle); font-size: var(--bs-body-font-size); font-weight: var(--bs-body-font-weight); text-align: var(--bs-body-text-align);">
                        </span></p><p><span style="background-color: transparent; color: var(--ot-text-subtitle); font-size: var(--bs-body-font-size); text-align: var(--bs-body-text-align);"><b>
                                                    Governing Law: </b></span><span style="background-color: transparent; color: var(--ot-text-subtitle); font-size: var(--bs-body-font-size); font-weight: var(--bs-body-font-weight); text-align: var(--bs-body-text-align);">These Terms shall be governed by and construed in accordance with the laws of United Stated Of America , without regard to its conflict of law provisions.
                        </span></p><p><span style="background-color: transparent; color: var(--ot-text-subtitle); font-size: var(--bs-body-font-size); font-weight: var(--bs-body-font-weight); text-align: var(--bs-body-text-align);"><br></span></p><p><span style="background-color: transparent; color: var(--ot-text-subtitle); font-size: var(--bs-body-font-size); text-align: var(--bs-body-text-align);"><b>
                                                    Contact Us: </b></span><span style="background-color: transparent; color: var(--ot-text-subtitle); font-size: var(--bs-body-font-size); font-weight: var(--bs-body-font-weight); text-align: var(--bs-body-text-align);">If you have any questions about these Terms, please contact us at&nbsp; Ones .

                                                    By accessing or using the Software, you agree to be bound by these Terms. If you do not agree to these Terms, please refrain from accessing or using the Software.</span><br></p>',

                'menu_show' => 'footer'
            ],

            [
                'name' => 'Our Missions',
                'slug' => 'our_missions',
                'content' =>
                '<p>At ' . setting('application_name') . ' , we are dedicated to providing a nurturing and enriching educational environment that empowers students to reach their full potential. Our mission is to foster academic excellence, character development, and lifelong learning in every student we serve.</p><p><br></p><h3><b style="color: var(--ot-text-subtitle); background-color: transparent; font-size: var(--bs-body-font-size); text-align: var(--bs-body-text-align);">Our Core Values</b></h3><p><b style="color: var(--ot-text-subtitle); background-color: transparent; font-size: var(--bs-body-font-size); text-align: var(--bs-body-text-align);"><br></b><br></p><p><b>
                        1. Excellence:
                        </b> We are committed to excellence in all aspects of education, striving to provide the highest quality teaching, resources, and support to our students.
                            </p><p><br></p><p><b>
                        2. Integrity:
                        </b> We uphold the highest standards of integrity, honesty, and ethical behavior in our interactions with students, parents, staff, and the community.
                            </p><p><br></p><p><b>
                        3. Respect:</b>
                        We foster a culture of respect, valuing the unique abilities, perspectives, and backgrounds of each individual within our school community.
                            </p><p><br></p><p><b>
                        4. Collaboration:
                            </b>  We believe in the power of collaboration and teamwork, working closely with students, parents, educators, and the community to achieve our shared goals.
                        </p><p><br></p><p><b>
                        5. Innovation:</b>
                        We embrace innovation and creativity, continuously seeking new and effective ways to enhance the learning experience and meet the evolving needs of our students.</p><p><br></p><p>
                            </p><p style="text-align: center;"><b><u>
                        Our Goals</u></b></p><p style="text-align: center;"><b><u><br></u></b></p><p style="text-align: center;"><b><u>
                        </u></b></p><ul><li><b>                            1. Academic Excellence:
                        </b>  We strive to provide rigorous academic programs that challenge and inspire students to achieve their highest academic potential.</li></ul><p><br></p><ul><li><b>
                        2. Character Development:</b>
                        We are committed to fostering the development of strong character traits such as honesty, responsibility, compassion, and resilience in our students.</li></ul><p><br></p><ul><li><b>
                        3. Lifelong Learning:
                        </b> We aim to instill a love of learning and a growth mindset in our students, empowering them to become lifelong learners who are curious, adaptable, and eager to explore new ideas and opportunities.</li></ul><p><br></p><ul><li><b>
                        4 Community Engagement:
                        </b> We seek to actively engage with parents, families, and the broader community to create a supportive and inclusive learning environment that nurtures the holistic development of our students.

                        Join Us in Our Mission
                        We invite you to join us in our mission to inspire and empower the next generation of leaders, thinkers, and innovators. </li></ul><p><br></p><p>Together, we can make a difference in the lives of our students and create a brighter future for all.

                        This sample content provides an overview of the schools mission, core values, goals, and an invitation for stakeholders to join in achieving those goals. You can customize it further to align with the specific mission and values of your school management application.</p>',

                'menu_show' => 'footer'
            ]
        ];


        $bn_pages = [
            [
                'name' => 'গোপনীয়তা নীতি',
                'slug' => 'privacy_policy',
                'content' => '<div class="elementor-element elementor-element-790b948d elementor-widget elementor-widget-text-editor" data-id="790b948d" data-element_type="widget" data-widget_type="text-editor.default" শৈলী ="--ফ্লেক্স-নির্দেশ: প্রাথমিক; --ফ্লেক্স-র্যাপ: প্রাথমিক; --জাস্টিফাই-সামগ্রী: প্রাথমিক; --অ্যালাইন-আইটেম: প্রাথমিক; --অ্যালাইন-সামগ্রী: প্রাথমিক; --গ্যাপ: প্রাথমিক; -- ফ্লেক্স-বেসিস: প্রাথমিক; --ফ্লেক্স-গ্রো: প্রাথমিক; --ফ্লেক্স-সঙ্কুচিত: প্রাথমিক; --অর্ডার: প্রাথমিক; --অ্যালাইন-স্ব: প্রাথমিক; ফ্লেক্স-বেসিস: var(--ফ্লেক্স-বেসিস); ফ্লেক্স -গ্রো: var(--ফ্লেক্স-গ্রো); ফ্লেক্স-সঙ্কুচিত: var(--ফ্লেক্স-সঙ্কুচিত); অর্ডার: var(--অর্ডার); align-self: var(--align-self); flex-direction : var(--ফ্লেক্স-ডাইরেকশন); ফ্লেক্স-র্যাপ: var(--ফ্লেক্স-র্যাপ); ন্যায্যতা-সামগ্রী: var(--জাস্টিফাই-কন্টেন্ট); সারিবদ্ধ-আইটেম: var(--সারিবদ্ধ-আইটেম); সারিবদ্ধ -সামগ্রী: var(--align-content); gap: var(--gap); অবস্থান: আপেক্ষিক; --swiper-theme-color: #000; --swiper-navigation-size: 44px; --swiper- পেজিনেশন-বুলেট-আকার: 6px; --swiper-পৃষ্ঠা-পৃষ্ঠা-বুলেট-অনুভূমিক-ব্যবধান: 6px; --উইজেট-স্পেসিং: 20px; রঙ: var( --e-global-color-text); ফন্ট-পরিবার: var( --e-global-typography-text-font-family ), &quot;Roboto&quot;, Sans-serif; প্রস্থ: 1280px; মার্জিন-নিচ: 0px; z-index: 3;"><div class="elementor-widget-container" style="transition: background .3s,border .3s,border-radius .3s,box-shadow .3s,transform var(--e -রূপান্তর-পরিবর্তন-সময়কাল,.4s); প্যাডিং: 0px 0px 100px;"><p style="margin-bottom: 0.9rem;"><span data-preserver-spaces="true">এই গোপনীয়তা নীতি নথিতে এমন ধরনের তথ্য রয়েছে যা সংগৃহীত এবং রেকর্ড করা হয় ' . setting('application_name') . ' এবং আমরা কিভাবে এটি ব্যবহার করি। এ ' . setting('application_name') . ', থেকে অ্যাক্সেসযোগ্য' . env('APP_URL') . ' , আমাদের প্রধান অগ্রাধিকারগুলির মধ্যে একটি হল আমাদের দর্শকদের গোপনীয়তা। এই গোপনীয়তা নীতি নথিতে তথ্যের প্রকার রয়েছে যা দ্বারা সংগৃহীত এবং রেকর্ড করা হয় ' . setting('application_name') . '&nbsp;এবং আমরা এটি কীভাবে ব্যবহার করি।</span></p><p style="margin-bottom: 0.9rem;"><span data-preserver-spaces="true">আপনার যদি অতিরিক্ত প্রশ্ন থাকে বা আমাদের গোপনীয়তা নীতি সম্পর্কে আরও তথ্যের প্রয়োজন হয়, তাহলে আমাদের সাথে যোগাযোগ করতে দ্বিধা করবেন না।</span></p><p style="margin-bottom: 0.9rem;"><span data-preserver-spaces="true">এই গোপনীয়তা নীতি শুধুমাত্র আমাদের অনলাইন ক্রিয়াকলাপের ক্ষেত্রে প্রযোজ্য এবং আমাদের ওয়েবসাইটের দর্শকদের জন্য তারা যে তথ্য শেয়ার করেছেন এবং/অথবা সংগ্রহ করেছেন তাদের জন্য বৈধ ' . setting('application_name') . '. এই নীতিটি এই ওয়েবসাইট ছাড়া অফলাইনে বা চ্যানেলের মাধ্যমে সংগ্রহ করা কোনো তথ্যের ক্ষেত্রে প্রযোজ্য নয়।</span></p><h3 style="margin-top: 0.5rem; margin-bottom: 1rem; font-family: inherit; "><span data-preserver-spaces="true">সম্মতি</span></h3><p style="margin-bottom: 0.9rem;"><span data-preserver-spaces="true">এর দ্বারা আমাদের ওয়েবসাইট ব্যবহার করে, আপনি এতদ্বারা আমাদের গোপনীয়তা নীতিতে সম্মত হন এবং এর শর্তাবলীতে সম্মত হন।</span></p><h3 style="margin-top: 0.5rem; margin-bottom: 1rem; font-family: inherit;" <span data-preserver-spaces="true">আমরা যে তথ্য সংগ্রহ করি</span></h3><p style="margin-bottom: 0.9rem;"><span data-preserver-spaces="true"> আপনাকে যে ব্যক্তিগত তথ্য প্রদান করতে বলা হয়েছে এবং কেন আপনাকে এটি প্রদান করতে বলা হয়েছে, আমরা যখন আপনাকে আপনার ব্যক্তিগত তথ্য প্রদান করতে বলব তখনই আপনাকে স্পষ্ট করে দেওয়া হবে।</span></p><p style ="margin-bottom: 0.9rem;"><span data-preserver-spaces="true">আপনি যদি আমাদের সাথে সরাসরি যোগাযোগ করেন, তাহলে আমরা আপনার সম্পর্কে অতিরিক্ত তথ্য পেতে পারি যেমন আপনার নাম, ইমেল ঠিকানা, ফোন নম্বর, এর বিষয়বস্তু আপনি যে বার্তা এবং/অথবা সংযুক্তিগুলি আমাদের পাঠাতে পারেন এবং অন্য যেকোন তথ্য প্রদান করতে পারেন।</span></p><p style="margin-bottom: 0.9rem;"><span data-preserver-spaces "সত্য "মার্জিন-টপ: 0.5rem; মার্জিন-নিচ: 1rem; font-family: inherit;"><span data-preserver-spaces="true">আমরা কীভাবে আপনার তথ্য ব্যবহার করি</span></h3><p style="margin-bottom: 0.9rem;"><span ডেটা -preserver-spaces="true">আমরা বিভিন্ন উপায়ে সংগ্রহ করা তথ্য ব্যবহার করি, যার মধ্যে রয়েছে:</span></p><ul style="margin-bottom: 0px; সীমানা: 0px; outline-style: প্রাথমিক; রূপরেখা-প্রস্থ: 0px; উল্লম্ব-সারিবদ্ধ: বেসলাইন; ব্যাকগ্রাউন্ড: স্বচ্ছ;"><li style="margin-top: 0px; মার্জিন-নিচ: 0px; সীমানা: 0px; outline-style: প্রাথমিক; রূপরেখা-প্রস্থ: 0px; উল্লম্ব-সারিবদ্ধ: বেসলাইন; পটভূমি: স্বচ্ছ;"><span data-preserver-spaces="true">আমাদের ওয়েবসাইট প্রদান, পরিচালনা এবং রক্ষণাবেক্ষণ করুন</span></li><li style="margin-top: 0px; মার্জিন-নিচ: 0px; সীমানা: 0px; outline-style: প্রাথমিক; রূপরেখা-প্রস্থ: 0px; উল্লম্ব-সারিবদ্ধ: বেসলাইন; পটভূমি: স্বচ্ছ;"><span data-preserver-spaces="true">আমাদের ওয়েবসাইট উন্নত করুন, ব্যক্তিগতকৃত করুন এবং প্রসারিত করুন</span></li><li style="margin-top: 0px; মার্জিন-নিচ: 0px; সীমানা: 0px; outline-style: প্রাথমিক; রূপরেখা-প্রস্থ: 0px; উল্লম্ব-সারিবদ্ধ: বেসলাইন; পটভূমি: স্বচ্ছ;"><span data-preserver-spaces="true">আপনি আমাদের ওয়েবসাইট কীভাবে ব্যবহার করেন তা বুঝুন এবং বিশ্লেষণ করুন</span></li><li style="margin-top: 0px; মার্জিন-নিচ: 0px; সীমানা: 0px; outline-style: প্রাথমিক; রূপরেখা-প্রস্থ: 0px; উল্লম্ব-সারিবদ্ধ: বেসলাইন; পটভূমি: স্বচ্ছ;"><span data-preserver-spaces="true">নতুন পণ্য, পরিষেবা, বৈশিষ্ট্য এবং কার্যকারিতা বিকাশ করুন</span></li><li style="margin-top: 0px; মার্জিন-নিচ: 0px; সীমানা: 0px; outline-style: প্রাথমিক; রূপরেখা-প্রস্থ: 0px; উল্লম্ব-সারিবদ্ধ: বেসলাইন; পটভূমি: স্বচ্ছ;"><span data-preserver-spaces="true">আপনার সাথে যোগাযোগ করুন, সরাসরি বা আমাদের অংশীদারদের একজনের মাধ্যমে, গ্রাহক পরিষেবা সহ, আপনাকে ওয়েবসাইট সম্পর্কিত আপডেট এবং অন্যান্য তথ্য প্রদান করতে, এবং বিপণন এবং প্রচারমূলক উদ্দেশ্যে</span></li><li style="margin-top: 0px; মার্জিন-নিচ: 0px; সীমানা: 0px; outline-style: প্রাথমিক; রূপরেখা-প্রস্থ: 0px; উল্লম্ব-সারিবদ্ধ: বেসলাইন; পটভূমি: স্বচ্ছ;"><span data-preserver-spaces="true">আপনাকে ইমেল পাঠান</span></li><li style="margin-top: 0px; মার্জিন-নিচ: 0px; সীমানা: 0px; outline-style: প্রাথমিক; রূপরেখা-প্রস্থ: 0px; উল্লম্ব-সারিবদ্ধ: বেসলাইন; পটভূমি: স্বচ্ছ;"><span data-preserver-spaces="true">জালিয়াতি খুঁজুন এবং প্রতিরোধ করুন</span></li></ul><h3 style="margin-top: 0.5rem; মার্জিন-নিচ: 1rem; font-family: inherit;"><span data-preserver-spaces="true">লগ ফাইল</span></h3><p style="margin-bottom: 0.9rem;"><span data-preserver- spaces="true"><span style="font-family: var( --e-global-typography-text-font-family ), &quot;Roboto&quot;, Sans-serif; ব্যাকগ্রাউন্ড-রঙ: স্বচ্ছ; ফন্ট-সাইজ: var(--BS-বডি-ফন্ট-সাইজ); ফন্ট-ওজন: var(--BS-বডি-ফন্ট-ওজন); text-align: var(--bs-body-text-align);"> '. setting('application_name') . '</span>&nbsp;লগ ফাইল ব্যবহার করার একটি আদর্শ পদ্ধতি অনুসরণ করে৷ এই ফাইল ভিজিটর লগ লগ যখন তারা ওয়েবসাইট পরিদর্শন. সমস্ত হোস্টিং কোম্পানি এটি করে এবং হোস্টিং পরিষেবার বিশ্লেষণের একটি অংশ। লগ ফাইলের মাধ্যমে সংগৃহীত তথ্যের মধ্যে রয়েছে ইন্টারনেট প্রোটোকল (IP) ঠিকানা, ব্রাউজারের ধরন, ইন্টারনেট পরিষেবা প্রদানকারী (ISP), তারিখ এবং সময় স্ট্যাম্প, উল্লেখ/প্রস্থান পৃষ্ঠা এবং সম্ভবত ক্লিকের সংখ্যা। এগুলো কোনো ব্যক্তিগতভাবে শনাক্তযোগ্য তথ্যের সাথে যুক্ত নয়। তথ্যের উদ্দেশ্য হল প্রবণতা বিশ্লেষণ করা, সাইট পরিচালনা করা, ওয়েবসাইটে ব্যবহারকারীদের গতিবিধি ট্র্যাক করা এবং জনসংখ্যা সংক্রান্ত তথ্য সংগ্রহ করা।</span></p><p style="margin-bottom: 0.9rem;">&nbsp;</span></p><h3 style="margin-top: 0.5rem; margin-bottom: 1rem; font-family: inherit;"><span ডেটা -preserver-spaces="true">কুকিজ এবং ওয়েব বীকন</span></h3><p style="margin-bottom: 0.9rem;"><span data-preserver-spaces="true">অন্য যেকোনও মত ওয়েবসাইট, ' . setting('application_name') . ' &nbsp;কুকিজ ব্যবহার করে।. এই কুকিগুলি ভিজিটরদের পছন্দ, এবং ভিজিটর অ্যাক্সেস বা ভিজিট করা ওয়েবসাইটের পৃষ্ঠাগুলি সহ তথ্য সংরক্ষণ করতে ব্যবহার করা হয়। ভিজিটরদের ব্রাউজারের ধরন এবং/অথবা অন্যান্য তথ্যের উপর ভিত্তি করে আমাদের ওয়েব পৃষ্ঠার বিষয়বস্তু কাস্টমাইজ করে ব্যবহারকারীদের অভিজ্ঞতা অপ্টিমাইজ করতে তথ্য ব্যবহার করা হয়।</span></p><h3 style="margin-top: 0.5rem; margin- নীচে: 1rem; font-family: inherit;"><span data-preserver-spaces="true">বিজ্ঞাপন অংশীদারদের গোপনীয়তা নীতি</span></h3><p style="margin-bottom: 0.9rem;"> <span data-preserver-spaces="true">এর প্রতিটি বিজ্ঞাপন অংশীদারের জন্য গোপনীয়তা নীতি খুঁজে পেতে আপনি এই তালিকাটি দেখতে পারেন ' . setting('application_name') . ' .</span></p><p style="margin-bottom: 0.9rem;"><span data-preserver-spaces="true">তৃতীয় পক্ষের বিজ্ঞাপন সার্ভার বা বিজ্ঞাপন নেটওয়ার্ক কুকিজ, জাভাস্ক্রিপ্ট, এর মতো প্রযুক্তি ব্যবহার করে অথবা ওয়েব বীকন যা তাদের নিজ নিজ বিজ্ঞাপনে ব্যবহৃত হয় এবং লিঙ্কে প্রদর্শিত হয় ' . setting('application_name') . ' , যা সরাসরি ব্যবহারকারীদের ব্রাউজারে পাঠানো হয়। যখন এটি ঘটে তখন তারা স্বয়ংক্রিয়ভাবে আপনার আইপি ঠিকানা গ্রহণ করে। এই প্রযুক্তিগুলি তাদের বিজ্ঞাপন প্রচারাভিযানের কার্যকারিতা পরিমাপ করতে এবং/অথবা আপনি যে ওয়েবসাইটগুলিতে যান সেই বিজ্ঞাপন সামগ্রীগুলিকে ব্যক্তিগতকৃত করতে ব্যবহার করা হয়৷</span></p><p style="margin-bottom: 0.9rem;" ><span data-preserver-spaces="true">মনে রাখবেন যে ' . setting('application_name') . ' &nbsp;থার্ড-পার্টি বিজ্ঞাপনদাতাদের দ্বারা ব্যবহৃত এই কুকিগুলিতে কোনও অ্যাক্সেস বা নিয়ন্ত্রণ নেই৷</span></p><h3 style="margin-top: 0.5rem; margin-bottom: 1rem; font-family: inherit;"><span data-preserver-spaces="true">তৃতীয় পক্ষের গোপনীয়তা নীতি</span></h3><p style="margin-bottom: 0.9rem;"><span data-preserver-spaces ="true"><span style="font-family: var( --e-global-typography-text-font-family ), &quot;Roboto&quot;, Sans-serif; ব্যাকগ্রাউন্ড-রং: স্বচ্ছ; font-size: var(--bs-body-font-size); font-weight: var(--bs-body-font-weight); text-align: var(--bs-body-text-align);"> ' . setting('application_name') . ' </span>&nbsp;গোপনীয়তা নীতি অন্যান্য বিজ্ঞাপনদাতা বা ওয়েবসাইটে প্রযোজ্য নয়৷ সুতরাং, আমরা আপনাকে আরও বিস্তারিত তথ্যের জন্য এই তৃতীয় পক্ষের বিজ্ঞাপন সার্ভারগুলির সংশ্লিষ্ট গোপনীয়তা নীতিগুলির সাথে পরামর্শ করার পরামর্শ দিচ্ছি। এটিতে তাদের অনুশীলন এবং নির্দিষ্ট বিকল্পগুলি কীভাবে অপ্ট আউট করতে হয় সে সম্পর্কে নির্দেশাবলী অন্তর্ভুক্ত থাকতে পারে।</span></p><p style="margin-bottom: 0.9rem;"><span data-preserver-spaces="true"> আপনি আপনার ব্রাউজার বিকল্পগুলির মাধ্যমে কুকিজ নিষ্ক্রিয় করতে বেছে নিতে পারেন। নির্দিষ্ট ওয়েব ব্রাউজারগুলির সাথে কুকি পরিচালনা সম্পর্কে আরও বিশদ তথ্য জানতে, এটি ব্রাউজারের নিজ নিজ ওয়েবসাইটে পাওয়া যেতে পারে৷</span></p><h3 style="margin-top: 0.5rem; margin-bottom: 1rem; font-family: inherit;"><span data-preserver-spaces="true">পেমেন্ট তথ্য গোপনীয়তা নীতি</span></h3><p style="margin-bottom: 0.9rem;"><span style= "ফন্ট-ফ্যামিলি: var( --e-global-typography-text-font-family), &quot;Roboto&quot;, Sans-serif; ব্যাকগ্রাউন্ড-রং: স্বচ্ছ; হরফ-আকার: var(--BS-বডি-ফন্ট -আকার); font-weight: var(-bs-body-font-weight); text-align: var(--bs-body-text-align);">' . setting('application_name') . '</span>&nbsp;তদনুসারে আপনার সমস্ত গোপনীয় তথ্য রক্ষা করার গুরুত্বকে দৃঢ়ভাবে স্বীকার করে৷ ' . setting('application_name') . '&nbsp;এর ওয়েবসাইটে সংগৃহীত ব্যবহারকারীর তথ্যের ভাল সুরক্ষা বজায় রাখে৷' . setting('application_name') . ' . ' . setting('application_name') . '&nbsp;ক্লায়েন্টদের ব্যক্তিগত তথ্য কখনও অন্য কোনও বহিরাগতের সাথে শেয়ার করে না। এই গোপনীয়তা নীতি Eduman-এর বর্তমান এবং প্রাক্তন উভয় ক্লায়েন্টের জন্য প্রযোজ্য। গোপনীয়তা নীতির সাথে একমত হওয়ার পরে, আপনি একজন ক্লায়েন্ট হিসাবে আমাদের সাইটে অ্যাক্সেস পাবেন। অন্যথায়, আপনি আমাদের ওয়েবসাইট ব্রাউজার হওয়ার জন্য উপযুক্ত নন। আমরা লগ ফাইলগুলিও বজায় রাখি এবং ফাইলগুলি আপডেট করি। আমাদের সমস্ত কার্যকলাপ সম্পূর্ণরূপে সুরক্ষিত যা কখনও বাইরের তৃতীয় ব্যক্তির সাথে ভাগ করে নেওয়া এবং ঘোষণা করা হবে না। এই গোপনীয়তা নীতিটিকে আরও শক্তিশালী করার জন্য পরিবর্তনযোগ্য তবে Eduman সতর্ক থাকে যাতে এটি কারও ক্ষতি না করে।</p><p style="margin-bottom: 0.9rem;">&nbsp;</p><h3 style="margin-top: 0.5rem; margin-bottom: 1rem; font-family: inherit;"><span data-preserver-spaces="true">রিফান্ড নীতিমালা</span></h3><p style="margin-bottom: 0.9rem;"><span style="font-family: var( --e-global-typography-text-font-family ), &quot;Roboto&quot;, Sans-serif; background-color: transparent; font-size: var(--bs-body-font-size); font-weight: var(--bs-body-font-weight); text-align: var(--bs-body-text-align);">' . setting('application_name') . '</span>&nbsp;কোনও লেনদেনের জন্য কোনও ফেরত বা চার্জব্যাক গ্রহণ করা হবে না।</p><p style="margin-bottom: 0.9rem;">কিন্তু যদি কোনও লেনদেন নিয়ে কোনও বিরোধ দেখা দেয় তবে আমরা যথাযথ বৈধতা এবং লেনদেনের প্রমাণ সহ লেনদেনের স্থিতি আপডেট করব যার জন্য ১৪-২১ কার্যদিবসের প্রয়োজন।&nbsp;</p><p style="margin-bottom: 0.9rem;">&nbsp;</p><h3 style="margin-top: 0.5rem; margin-bottom: 1rem; font-family: inherit;"><span data-preserver-spaces="true">CCPA গোপনীয়তা অধিকার (আমার ব্যক্তিগত তথ্য বিক্রি করবেন না)</span></h3><p style="margin-bottom: 0.9rem;"><span data-preserver-spaces="true">CCPA-এর অধীনে, অন্যান্য অধিকারের মধ্যে, ক্যালিফোর্নিয়ার ভোক্তাদের অধিকার রয়েছে:</span></p><p style="margin-bottom: 0.9rem;"><span data-preserver-spaces="true">গ্রাহকের তথ্য সংগ্রহকারী একটি ব্যবসাকে গ্রাহকদের সম্পর্কে সংগৃহীত বিভাগ এবং নির্দিষ্ট ব্যক্তিগত তথ্য প্রকাশ করার জন্য অনুরোধ করুন।</span></p><p style="margin-bottom: 0.9rem;"><span data-preserver-spaces="true">কোনও ব্যবসা প্রতিষ্ঠানকে অনুরোধ করুন যে তারা গ্রাহকের সম্পর্কে যে কোনও ব্যক্তিগত তথ্য সংগ্রহ করেছে তা মুছে ফেলুক।</span></p><p style="margin-bottom: 0.9rem;"><span data-preserver-spaces="true">যে ব্যবসা প্রতিষ্ঠান গ্রাহকের তথ্য বিক্রি করে, তাদের যেন গ্রাহকের তথ্য বিক্রি না করা হয়, সেই প্রতিষ্ঠানকে অনুরোধ করুন।</span></p><p style="margin-bottom: 0.9rem;"><span data-preserver-spaces="true">যদি আপনি কোন অনুরোধ করেন, তাহলে আপনার সাড়া দেওয়ার জন্য আমাদের কাছে এক মাস সময় আছে। আপনি যদি এই অধিকারগুলির কোনটি প্রয়োগ করতে চান, তাহলে অনুগ্রহ করে আমাদের সাথে যোগাযোগ করুন।</span></p><h3 style="margin-top: 0.5rem; margin-bottom: 1rem; font-family: inherit;"><span data-preserver-spaces="true">জিডিপিআর ডেটা সুরক্ষা অধিকার</span></h3><p style="margin-bottom: 0.9rem;"><span data-preserver-spaces="true">আমরা নিশ্চিত করতে চাই যে আপনি আপনার সমস্ত ডেটা সুরক্ষা অধিকার সম্পর্কে সম্পূর্ণরূপে সচেতন। প্রতিটি ব্যবহারকারীর নিম্নলিখিত অধিকার রয়েছে:</span></p><p style="margin-bottom: 0.9rem;"><span data-preserver-spaces="true">অ্যাক্সেসের অধিকার - আপনার তথ্যের কপি অনুরোধ করার অধিকার আপনার আছে। এই পরিষেবার জন্য আমরা আপনার কাছ থেকে সামান্য ফি নিতে পারি।</span></p><p style="margin-bottom: 0.9rem;"><span data-preserver-spaces="true">সংশোধনের অধিকার - আপনার কাছে এমন কোনও তথ্য সংশোধন করার অনুরোধ করার অধিকার আছে যা আপনি ভুল বলে মনে করেন। আপনার কাছে এমন তথ্য সম্পূর্ণ করার অনুরোধ করার অধিকারও আছে যা আপনি অসম্পূর্ণ বলে মনে করেন।</span></p><p style="margin-bottom: 0.9rem;"><span data-preserver-spaces="true">মুছে ফেলার অধিকার - কিছু শর্তের অধীনে, আপনার ডেটা মুছে ফেলার অনুরোধ করার অধিকার আপনার আছে।</span></p><p style="margin-bottom: 0.9rem;"><span data-preserver-spaces="true">প্রক্রিয়াকরণ সীমাবদ্ধ করার অধিকার - আপনার কাছে কিছু শর্তের অধীনে আপনার ডেটা প্রক্রিয়াকরণ সীমাবদ্ধ করার অনুরোধ করার অধিকার রয়েছে।</span></p><p style="margin-bottom: 0.9rem;"><span data-preserver-spaces="true">প্রক্রিয়াকরণের বিরুদ্ধে আপত্তি জানানোর অধিকার – কিছু শর্তের অধীনে, আপনার ডেটা প্রক্রিয়াকরণের বিরুদ্ধে আপত্তি জানানোর অধিকার আপনার আছে।</span></p><p style="margin-bottom: 0.9rem;"><span data-preserver-spaces="true">ডেটা পোর্টেবিলিটির অধিকার – আপনার কাছে অনুরোধ করার অধিকার আছে যে আমরা যে ডেটা সংগ্রহ করেছি তা অন্য কোনও সংস্থায়, অথবা সরাসরি আপনার কাছে, কিছু শর্তের অধীনে স্থানান্তর করি।</span></p><p style="margin-bottom: 0.9rem;"><span data-preserver-spaces="true">যদি আপনি কোন অনুরোধ করেন, তাহলে আপনার সাড়া দেওয়ার জন্য আমাদের কাছে এক মাস সময় আছে। আপনি যদি এই অধিকারগুলির কোনটি প্রয়োগ করতে চান, তাহলে অনুগ্রহ করে আমাদের সাথে যোগাযোগ করুন।</span></p><h3 style="margin-top: 0.5rem; margin-bottom: 1rem; font-family: inherit;"><span data-preserver-spaces="true">শিশুদের তথ্য</span></h3><p style="margin-bottom: 0.9rem;"><span data-preserver-spaces="true">আমাদের অগ্রাধিকারের আরেকটি অংশ হল ইন্টারনেট ব্যবহারের সময় শিশুদের সুরক্ষা প্রদান করা। আমরা বাবা-মা এবং অভিভাবকদের তাদের অনলাইন কার্যকলাপ পর্যবেক্ষণ, অংশগ্রহণ এবং/অথবা পর্যবেক্ষণ এবং নির্দেশনা দেওয়ার জন্য উৎসাহিত করি।</span></p><p style="margin-bottom: 0.9rem;"><span data-preserver-spaces="true"><span style="font-family: var( --e-global-typography-text-font-family ), &quot;Roboto&quot;, Sans-serif; background-color: transparent; font-size: var(--bs-body-font-size); font-weight: var(--bs-body-font-weight); text-align: var(--bs-body-text-align);"> ' . setting('application_name') . '</span>&nbsp; ১৩ বছরের কম বয়সী শিশুদের কাছ থেকে জেনেশুনে কোনও ব্যক্তিগত শনাক্তযোগ্য তথ্য সংগ্রহ করে না। যদি আপনি মনে করেন যে আপনার সন্তান আমাদের ওয়েবসাইটে এই ধরণের তথ্য সরবরাহ করেছে, তাহলে আমরা আপনাকে অবিলম্বে আমাদের সাথে যোগাযোগ করার জন্য জোরালোভাবে উৎসাহিত করছি এবং আমরা আমাদের রেকর্ড থেকে এই ধরণের তথ্য দ্রুত অপসারণের জন্য যথাসাধ্য চেষ্টা করব।</span></p><div><span data-preserver-spaces="true"><br></span></div></div></div><div class="elementor-element elementor-element-4f36e2b7 elementor-widget__width-initial elementor-absolute elementor-widget elementor-widget-spacer" data-id="4f36e2b7" data-element_type="widget" data-settings="{&quot;_position&quot;:&quot;absolute&quot;}" data-widget_type="spacer.default" style="--flex-direction: initial; --flex-wrap: initial; --justify-content: initial; --align-items: initial; --align-content: initial; --gap: initial; --flex-basis: initial; --flex-grow: initial; --flex-shrink: initial; --order: initial; --align-self: initial; flex-basis: var(--flex-basis); flex-grow: var(--flex-grow); flex-shrink: var(--flex-shrink); order: var(--order); align-self: var(--align-self); flex-direction: var(--flex-direction); flex-wrap: var(--flex-wrap); justify-content: var(--justify-content); align-items: var(--align-items); align-content: var(--align-content); gap: var(--gap); position: absolute; --swiper-theme-color: #000; --swiper-navigation-size: 44px; --swiper-pagination-bullet-size: 6px; --swiper-pagination-bullet-horizontal-gap: 6px; --widgets-spacing: 20px; z-index: 1; width: var( --container-widget-width, 100vw ); margin-bottom: 0px; max-width: 100vw; --spacer-size: 100vh; --container-widget-width: 100vw; --container-widget-flex-grow: 0; top: -0.5px; right: 551px; color: rgb(51, 51, 51); font-family: -apple-system, &quot;system-ui&quot;, &quot;Segoe UI&quot;, Roboto, &quot;Helvetica Neue&quot;, Arial, &quot;Noto Sans&quot;, sans-serif, &quot;Apple Color Emoji&quot;, &quot;Segoe UI Emoji&quot;, &quot;Segoe UI Symbol&quot;, &quot;Noto Color Emoji&quot;;"><div class="elementor-widget-container" style="transition: background .3s,border .3s,border-radius .3s,box-shadow .3s,transform var(--e-transform-transition-duration,.4s); background-color: transparent; background-image: radial-gradient(rgba(44, 255, 0, 0.06) 0%, rgba(0, 0, 0, 0) 70%);"><div class="elementor-spacer"></div></div></div>',

                'menu_show' => 'footer'
            ],
            [
                'name' => 'সহায়তা নীতি',
                'slug' => 'support_policy',
                'content' =>
                '<h3 dir="ltr" style="line-height:1.38;margin-top:14pt;margin-bottom:4pt;"><span style="font-size:13pt;font-family:Arial,sans-serif;color:#000000;background-color:transparent;font-weight:700;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;">ওনেস্ট স্কুলড ম্যানেজমেন্ট সিস্টেমের জন্য সহায়তা নীতি সহায়তা নীতি</span></h3><p dir="ltr" style="line-height:1.38;margin-top:12pt;margin-bottom:12pt;"><span style="font-size:11pt;font-family:Arial,sans-serif;color:#000000;background-color:transparent;font-weight:700;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;">সহায়তা নীতি</span></p><p dir="ltr" style="line-height:1.38;margin-top:12pt;margin-bottom:12pt;"><span style="font-size:11pt;font-family:Arial,sans-serif;color:#000000;background-color:transparent;font-weight:700;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;">১. সহায়তার পরিধি</span><span style="font-size:11pt;font-family:Arial,sans-serif;color:#000000;background-color:transparent;font-weight:700;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;"><br></span><span style="font-size:11pt;font-family:Arial,sans-serif;color:#000000;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;">আমরা নিম্নলিখিত ক্ষেত্রে সহায়তা প্রদান করি:</span></p><ul style="margin-top:0;margin-bottom:0;padding-inline-start:48px;"><li dir="ltr" style="list-style-type:disc;font-size:11pt;font-family:Arial,sans-serif;color:#000000;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;" aria-level="1"><p dir="ltr" style="line-height:1.38;margin-top:12pt;margin-bottom:0pt;" role="presentation"><span style="font-size:11pt;font-family:Arial,sans-serif;color:#000000;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;">সেটআপ এবং কনফিগারেশন।</span></p></li><li dir="ltr" style="list-style-type:disc;font-size:11pt;font-family:Arial,sans-serif;color:#000000;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;" aria-level="1"><p dir="ltr" style="line-height:1.38;margin-top:0pt;margin-bottom:0pt;" role="presentation"><span style="font-size:11pt;font-family:Arial,sans-serif;color:#000000;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;">প্রযুক্তিগত সমস্যা সমাধান।</span></p></li><li dir="ltr" style="list-style-type:disc;font-size:11pt;font-family:Arial,sans-serif;color:#000000;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;" aria-level="1"><p dir="ltr" style="line-height:1.38;margin-top:0pt;margin-bottom:12pt;" role="presentation"><span style="font-size:11pt;font-family:Arial,sans-serif;color:#000000;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;">বৈশিষ্ট্য-সম্পর্কিত প্রশ্ন।</span></p></li></ul><p dir="ltr" style="line-height:1.38;margin-top:12pt;margin-bottom:12pt;"><span style="font-size:11pt;font-family:Arial,sans-serif;color:#000000;background-color:transparent;font-weight:700;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;">2. সাপোর্ট চ্যানেল</span></p><ul style="margin-top:0;margin-bottom:0;padding-inline-start:48px;"><li dir="ltr" style="list-style-type:disc;font-size:11pt;font-family:Arial,sans-serif;color:#000000;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;" aria-level="1"><p dir="ltr" style="line-height:1.38;margin-top:12pt;margin-bottom:0pt;" role="presentation"><span style="font-size:11pt;font-family:Arial,sans-serif;color:#000000;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;">ইমেইল: [sales.onesttech.com]</span></p></li><li dir="ltr" style="list-style-type:disc;font-size:11pt;font-family:Arial,sans-serif;color:#000000;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;" aria-level="1"><p dir="ltr" style="line-height:1.38;margin-top:0pt;margin-bottom:12pt;" role="presentation"><span style="font-size:11pt;font-family:Arial,sans-serif;color:#000000;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;">হোয়াটসঅ্যাপ: [+৮৮০ ১৯৫৯-৩৩৫৫৫৫]</span></p></li></ul><p dir="ltr" style="line-height:1.38;margin-top:12pt;margin-bottom:12pt;"><span style="font-size:11pt;font-family:Arial,sans-serif;color:#000000;background-color:transparent;font-weight:700;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;">৩. প্রতিক্রিয়া সময়</span></p><ul style="margin-top:0;margin-bottom:0;padding-inline-start:48px;"><li dir="ltr" style="list-style-type:disc;font-size:11pt;font-family:Arial,sans-serif;color:#000000;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;" aria-level="1"><p dir="ltr" style="line-height:1.38;margin-top:12pt;margin-bottom:0pt;" role="presentation"><span style="font-size:11pt;font-family:Arial,sans-serif;color:#000000;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;">সাধারণ প্রশ্ন: ৪৮ কর্মঘণ্টার মধ্যে উত্তর।</span></p></li><li dir="ltr" style="list-style-type:disc;font-size:11pt;font-family:Arial,sans-serif;color:#000000;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;" aria-level="1"><p dir="ltr" style="line-height:1.38;margin-top:0pt;margin-bottom:12pt;" role="presentation"><span style="font-size:11pt;font-family:Arial,sans-serif;color:#000000;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;">গুরুত্বপূর্ণ সমস্যা (যেমন, পরিষেবা বন্ধ থাকার সময়): ২৪ ঘন্টার মধ্যে প্রতিক্রিয়া।</span></p></li></ul><p dir="ltr" style="line-height:1.38;margin-top:12pt;margin-bottom:12pt;"><span style="font-size:11pt;font-family:Arial,sans-serif;color:#000000;background-color:transparent;font-weight:700;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;">৪. আপডেট এবং রক্ষণাবেক্ষণ</span><span style="font-size:11pt;font-family:Arial,sans-serif;color:#000000;background-color:transparent;font-weight:700;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;"><br></span><span style="font-size:11pt;font-family:Arial,sans-serif;color:#000000;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;">বৈশিষ্ট্য বৃদ্ধি এবং বাগ সংশোধনের জন্য নিয়মিত আপডেট প্রদান করা হয়। নির্ধারিত রক্ষণাবেক্ষণের আগে বিজ্ঞপ্তি পাঠানো হবে।</span></p><p><span id="docs-internal-guid-500ba9c7-7fff-1baf-821f-835a1517b432"></span></p><p dir="ltr" style="line-height:1.38;margin-top:12pt;margin-bottom:12pt;"><span style="font-size:11pt;font-family:Arial,sans-serif;color:#000000;background-color:transparent;font-weight:400;font-style:normal;font-variant:normal;text-decoration:none;vertical-align:baseline;white-space:pre;white-space:pre-wrap;">আপনি যদি এই নীতিগুলি আরও কাস্টমাইজ করতে চান বা আরও বিশদ যোগ করতে চান তবে আমাকে জানান!</span></p>',

                'menu_show' => 'footer'
            ],
            [
                'name' => 'শর্তাবলী',
                'slug' => 'terms_conditions',
                'content' =>
                '<p><b>ব্যবহারের শর্তাবলী ' . setting('application_name') . '
                </b></p><p><b><br></b>
                                            এই নিয়ম ও শর্তাবলী স্কুল ম্যানেজমেন্ট সফ্টওয়্যার দ্বারা প্রদত্ত আপনার অ্যাক্সেস এবং ব্যবহার নিয়ন্ত্রণ করে ' . setting('application_name') . ' . সফ্টওয়্যার অ্যাক্সেস বা ব্যবহার করে, আপনি এই শর্তাবলী দ্বারা আবদ্ধ হতে সম্মত হন। আপনি যদি এই শর্তাবলীতে সম্মত না হন তবে অনুগ্রহ করে সফটওয়্যারটি অ্যাক্সেস করা বা ব্যবহার করা থেকে বিরত থাকুন।
                        </p><p><br></p><p><b>
                        শর্তাদি গ্রহণ: </b>সফ্টওয়্যার অ্যাক্সেস বা ব্যবহার করে, আপনি এই শর্তাবলী দ্বারা আবদ্ধ হতে সম্মত হন। আপনি যদি এই চুক্তির সমস্ত শর্তাবলীর সাথে সম্মত না হন তবে আপনি অবশ্যই সফ্টওয়্যারটি ব্যবহার করবেন না৷</p><p><br></p><p>
                        </p><p><b style="color: var(--ot-text-subtitle); ব্যাকগ্রাউন্ড-রং: স্বচ্ছ; font-size: var(--bs-body-font-size); text- align: var(--bs-body-text-align);">সফ্টওয়্যারের ব্যবহার:</b><span style="color: var(--ot-text-subtitle); ব্যাকগ্রাউন্ড-রং: স্বচ্ছ; হরফ-আকার: var(--bs-বডি-ফন্ট-আকার); ফন্ট-ওজন: var(--BS-বডি-ফন্ট-ওজন); টেক্সট-সারিবদ্ধ: var(--BS-বডি-টেক্সট-সারিবদ্ধ) ;"> সফ্টওয়্যারটি শুধুমাত্র স্কুল, কলেজ এবং বিশ্ববিদ্যালয় সহ কিন্তু সীমাবদ্ধ নয় শিক্ষা প্রতিষ্ঠান পরিচালনার উদ্দেশ্যে প্রদান করা হয়৷ আপনি কোনো অবৈধ বা অননুমোদিত উদ্দেশ্যে সফ্টওয়্যার ব্যবহার না করতে সম্মত হন৷</span></p><p><span style="color: var(--ot-text-subtitle); background-color: transparent; font -আকার: var(--bs-বডি-ফন্ট-আকার); ফন্ট-ওজন: var(--BS-বডি-ফন্ট-ওজন); টেক্সট-সারিবদ্ধ: var(--BS-বডি-টেক্সট-সারিবদ্ধ); "><br></span></p><p><span style="color: var(--ot-text-subtitle); ব্যাকগ্রাউন্ড-রঙ: স্বচ্ছ; ফন্ট-সাইজ: var(--bs- body-font-size); font-weight: var(--bs-body-font-weight); text-align: var(--bs-body-text-align);">
                        </span></p><p><span style="color: var(--ot-text-subtitle); ব্যাকগ্রাউন্ড-রং: স্বচ্ছ; ফন্ট-সাইজ: var(--bs-body-font-size ); ফন্ট-ওজন: var(--bs-body-font-weight); text-align: var(--bs-body-text-align);"><b>ব্যবহারকারীর অ্যাকাউন্ট: </b></ span><span style="color: var(--ot-text-subtitle); ব্যাকগ্রাউন্ড-রং: স্বচ্ছ; font-size: var(-bs-body-font-size); font-weight: var(- -bs-body-font-weight); text-align: var(--bs-body-text-align);">সফ্টওয়্যারের কিছু বৈশিষ্ট্য অ্যাক্সেস করার জন্য আপনাকে একটি অ্যাকাউন্ট তৈরি করতে হতে পারে৷ আপনার অ্যাকাউন্টের শংসাপত্রের গোপনীয়তা বজায় রাখার জন্য এবং আপনার অ্যাকাউন্টের অধীনে হওয়া সমস্ত কার্যকলাপের জন্য আপনি দায়ী৷</span></p><p><span style="color: var(--ot-text-subtitle); ব্যাকগ্রাউন্ড-রঙ: স্বচ্ছ; ফন্ট-আকার: var(--bs-বডি-ফন্ট-আকার); ফন্ট-ওজন: var(--BS-বডি-ফন্ট-ওজন); পাঠ্য-সারিবদ্ধ: var(--bs- body-text-align);"><br></span></p><p><span style="color: var(--ot-text-subtitle); ব্যাকগ্রাউন্ড-রঙ: স্বচ্ছ; ফন্ট-সাইজ : var(--bs-body-font-size); font-weight: var(--bs-body-font-weight); text-align: var(--bs-body-text-align);"> <br></span></p><p><span style="color: var(--ot-text-subtitle); ব্যাকগ্রাউন্ড-রং: স্বচ্ছ; ফন্ট-সাইজ: var(--bs-body- font-size); text-align: var(--bs-body-text-align);"><b>

                                                    গোপনীয়তা:</b></span><span style="color: var(--ot-text-subtitle); ব্যাকগ্রাউন্ড-রং: স্বচ্ছ; ফন্ট-সাইজ: var(--bs-body-font-size) ; font-weight: var(--bs-body-font-weight); text-align: var(--bs-body-text-align);"> আমরা আপনার গোপনীয়তা রক্ষা করতে প্রতিশ্রুতিবদ্ধ। আমরা কীভাবে আপনার ব্যক্তিগত তথ্য সংগ্রহ, ব্যবহার এবং প্রকাশ করি তা আমাদের গোপনীয়তা নীতি রূপরেখা দেয়। সফ্টওয়্যার ব্যবহার করে, আপনি গোপনীয়তা নীতিতে বর্ণিত আপনার ব্যক্তিগত তথ্য সংগ্রহ, ব্যবহার এবং প্রকাশে সম্মত হন।</span></p><p><span style="color: var(--ot- টেক্সট-সাবটাইটেল; ব্যাকগ্রাউন্ড-রং: স্বচ্ছ; ফন্ট-আকার: var(--bs-বডি-ফন্ট-সাইজ); হরফ-ওজন: var(--bs-বডি-ফন্ট-ওজন); পাঠ্য-সারিবদ্ধ: var (--bs-body-text-align);"><br></span></p><p><span style="color: var(--ot-text-subtitle); ব্যাকগ্রাউন্ড-রঙ: স্বচ্ছ; ফন্ট-আকার: var(--bs-বডি-ফন্ট-আকার); হরফ-ওজন: var(--BS-বডি-ফন্ট-ওজন); টেক্সট-সারিবদ্ধ: var(--BS-বডি-টেক্সট- সারিবদ্ধ);
                        </span></p><p><span style="color: var(--ot-text-subtitle); ব্যাকগ্রাউন্ড-রং: স্বচ্ছ; ফন্ট-সাইজ: var(--bs-body-font-size ); পাঠ্য-সারিবদ্ধ: var(--bs-বডি-টেক্সট-সারিবদ্ধ);"><b>
                                                    বুদ্ধিবৃত্তিক সম্পত্তি:</b></span><span style="color: var(--ot-text-subtitle); ব্যাকগ্রাউন্ড-রং: স্বচ্ছ; ফন্ট-সাইজ: var(--bs-body-font-size ); font-weight: var(--bs-body-font-weight); text-align: var(--bs-body-text-align);"> সফটওয়্যার এবং এর মূল বিষয়বস্তু, বৈশিষ্ট্য এবং কার্যকারিতা হল মালিক ' . setting('application_name') . ' এবং আন্তর্জাতিক কপিরাইট, ট্রেডমার্ক, পেটেন্ট, ট্রেড সিক্রেট এবং অন্যান্য মেধা সম্পত্তি বা মালিকানা অধিকার আইন দ্বারা সুরক্ষিত।</span></p><p><span style="color: var(--ot-text-subtitle) ); ব্যাকগ্রাউন্ড-রং: স্বচ্ছ; ফন্ট-আকার: var(--bs-বডি-ফন্ট-সাইজ); ফন্ট-ওজন: var(--bs-বডি-ফন্ট-ওজন); পাঠ্য-সারিবদ্ধ: var(-- bs-body-text-align);"><br></span></p><p><span style="color: var(--ot-text-subtitle); ব্যাকগ্রাউন্ড-রঙ: স্বচ্ছ; ফন্ট -আকার: var(--bs-বডি-ফন্ট-আকার); ফন্ট-ওজন: var(--BS-বডি-ফন্ট-ওজন); টেক্সট-সারিবদ্ধ: var(--BS-বডি-টেক্সট-সারিবদ্ধ); ">
                                                    </span></p><p><span style="color: var(--ot-text-subtitle); ব্যাকগ্রাউন্ড-রং: স্বচ্ছ; ফন্ট-সাইজ: var(--bs-body-font-size ); পাঠ্য-সারিবদ্ধ: var(--bs-বডি-টেক্সট-সারিবদ্ধ);"><b>
                                                                                দায়বদ্ধতার সীমাবদ্ধতা:</b></span><span style="color: var(--ot-text-subtitle); ব্যাকগ্রাউন্ড-রং: স্বচ্ছ; ফন্ট-সাইজ: var(--bs-body-font- আকার); font-weight: var(--bs-body-font-weight); text-align: var(--bs-body-text-align);"> কোন ঘটনাতেই হবে না
                                                    ' . setting('application_name') . ' যেকোন পরোক্ষ, আনুষঙ্গিক, বিশেষ, আনুষঙ্গিক, বা শাস্তিমূলক ক্ষতির জন্য দায়ী হতে হবে, যার মধ্যে সফ্টওয়্যার ব্যবহার বা ব্যবহারে অক্ষমতা থেকে উদ্ভূত লাভ, ডেটা বা সদিচ্ছার ক্ষতি সহ কিন্তু সীমাবদ্ধ নয়৷</span></p> <p><span style="color: var(--ot-text-subtitle); ব্যাকগ্রাউন্ড-রং: স্বচ্ছ; font-size: var(--bs-body-font-size); font-weight: var( --bs-body-font-weight); text-align: var(--bs-body-text-align);"><br></span></p><p><span style="color : var(--ot-টেক্সট-সাবটাইটেল); ব্যাকগ্রাউন্ড-রঙ: স্বচ্ছ; হরফ-আকার: var(--BS-বডি-ফন্ট-সাইজ); হরফ-ওজন: var (--BS-বডি-ফন্ট-ওজন ); text-align: var(--bs-body-text-align);">
                                                    </span></p><p><span style="background-color: transparent; color: var(--ot-text-subtitle); font-size: var(--bs-body-font-size ); text-align: var(--bs-body-text-align);"><b>শর্তাবলীতে পরিবর্তন:</b></span><span style="background-color: transparent; color: var (--ot-টেক্সট-সাবটাইটেল); ফন্ট-সাইজ: var(--bs-বডি-ফন্ট-সাইজ); হরফ-ওজন: var(--BS-বডি-ফন্ট-ওজন); পাঠ্য-সারিবদ্ধ: var( --bs-body-text-align);"> আমরা যে কোনো সময় এই শর্তাবলী পরিবর্তন বা প্রতিস্থাপন করার অধিকার সংরক্ষণ করি৷ যদি একটি সংশোধন বস্তুগত হয়, আমরা যেকোনো নতুন শর্ত কার্যকর হওয়ার অন্তত 30 দিনের নোটিশ প্রদান করব। কোন বস্তুগত পরিবর্তন গঠন করে তা আমাদের নিজস্ব বিবেচনার ভিত্তিতে নির্ধারণ করা হবে।</span></p><p><span style="background-color: transparent; color: var(--ot-text-subtitle); font- আকার: var(--BS-বডি-ফন্ট-আকার); ফন্ট-ওজন: var(--BS-বডি-ফন্ট-ওজন); টেক্সট-সারিবদ্ধ: var(--BS-বডি-টেক্সট-সারিবদ্ধ);" ><br></span></p><p><span style="background-color: transparent; color: var(--ot-text-subtitle); font-size: var(--bs-body -font-size); font-weight: var(--bs-body-font-weight); text-align: var(--bs-body-text-align);">
                                                    </span></p><p><span style="background-color: transparent; color: var(--ot-text-subtitle); font-size: var(--bs-body-font-size ); পাঠ্য-সারিবদ্ধ: var(--bs-বডি-টেক্সট-সারিবদ্ধ);"><b>
                                                                                পরিচালনা আইন: </b></span><span style="background-color: transparent; color: var(--ot-text-subtitle); font-size: var(--bs-body-font-size ); font-weight: var(--bs-body-font-weight); text-align: var(--bs-body-text-align);">এই শর্তাবলী দ্বারা নিয়ন্ত্রিত হবে এবং এর সাথে সঙ্গতিপূর্ণ হবে মার্কিন যুক্তরাষ্ট্রের আইন, তার আইনের বিধানের বিরোধ বিবেচনা ছাড়াই।
                                                    </span></p><p><span style="background-color: transparent; color: var(--ot-text-subtitle); font-size: var(--bs-body-font-size ); ফন্ট-ওজন: var(--bs-body-font-weight); টেক্সট-সারিবদ্ধ: var(--bs-বডি-টেক্সট-সারিবদ্ধ);"><br></span><span style="background-color: transparent; color: var(--ot-text-subtitle); font-size: var(-bs-body-font-size); text-align: var(- -বিএস-বডি-টেক্সট-সারিবদ্ধ);"><b>
                                                                                আমাদের সাথে যোগাযোগ করুন: </b></span><span style="background-color: transparent; color: var(--ot-text-subtitle); font-size: var(--bs-body-font-size ); font-weight: var(--bs-body-font-weight); text-align: var(--bs-body-text-align);">এই শর্তাবলী সম্পর্কে আপনার কোন প্রশ্ন থাকলে, অনুগ্রহ করে আমাদের সাথে যোগাযোগ করুন এ&nbsp; ওগুলো

                                                                                সফ্টওয়্যার অ্যাক্সেস বা ব্যবহার করে, আপনি এই শর্তাবলী দ্বারা আবদ্ধ হতে সম্মত হন। আপনি যদি এই শর্তাবলীতে সম্মত না হন তবে অনুগ্রহ করে সফটওয়্যার অ্যাক্সেস বা ব্যবহার করা থেকে বিরত থাকুন৷</span><br></p>',

                'menu_show' => 'footer'
            ],

            [
                'name' => 'আমাদের মিশন',
                'slug' => 'our_missions',
                'content' =>
                '<p>At ' . setting('application_name') . ' , আমরা একটি লালনশীল এবং সমৃদ্ধ শিক্ষামূলক পরিবেশ প্রদানের জন্য নিবেদিত যা শিক্ষার্থীদের তাদের পূর্ণ সম্ভাবনায় পৌঁছানোর ক্ষমতা দেয়। আমাদের লক্ষ্য হল শিক্ষাগত উৎকর্ষতা, চরিত্রের বিকাশ, এবং আমরা যে সকল শিক্ষার্থীকে সেবা করি তাদের আজীবন শিক্ষা লাভ করা।</p><p><br></p><h3><b style="color: var(--ot-text-subtitle); background-color: transparent; font-size: var(--bs-body-font-size); text-align: var(--bs-body-text-align);">আমাদের মূল মূল্যবোধ</b></h3><p><b style="color: var(--ot-text-subtitle); background-color: transparent; font-size: var(--bs-body-font-size); text-align: var(--bs-body-text-align);"><br></b><br></p><p><b>
                ১. শ্রেষ্ঠত্ব : </b>আমরা শিক্ষার সমস্ত দিকগুলিতে শ্রেষ্ঠত্বের জন্য প্রতিশ্রুতিবদ্ধ, আমাদের শিক্ষার্থীদের সর্বোচ্চ মানের শিক্ষাদান, সংস্থান এবং সহায়তা প্রদানের জন্য সচেষ্ট।
                    </p><p><br></p><p><b>
                ২. সততা : </b>ছাত্র, পিতামাতা, কর্মচারী এবং সম্প্রদায়ের সাথে আমাদের মিথস্ক্রিয়াতে আমরা সততা, সততা এবং নৈতিক আচরণের সর্বোচ্চ মান বজায় রাখি।
                    </p><p><br></p><p><b>
                ৩. সম্মান :</b>আমরা আমাদের স্কুল সম্প্রদায়ের মধ্যে প্রতিটি ব্যক্তির অনন্য ক্ষমতা, দৃষ্টিভঙ্গি এবং পটভূমিকে মূল্যায়ন করে শ্রদ্ধার সংস্কৃতি গড়ে তুলি।
                    </p><p><br></p><p><b>
                ৪. সহযোগিতা : </b>আমরা আমাদের ভাগ করা লক্ষ্য অর্জনের জন্য ছাত্র, পিতামাতা, শিক্ষাবিদ এবং সম্প্রদায়ের সাথে ঘনিষ্ঠভাবে কাজ করে সহযোগিতা এবং দলবদ্ধতার শক্তিতে বিশ্বাস করি।
                </p><p><br></p><p><b>
                ৫. উদ্ভাবন :</b>
                আমরা উদ্ভাবন এবং সৃজনশীলতাকে আলিঙ্গন করি, শেখার অভিজ্ঞতা বাড়াতে এবং আমাদের শিক্ষার্থীদের ক্রমবর্ধমান চাহিদা মেটাতে ক্রমাগত নতুন এবং কার্যকর উপায় খুঁজি।</p><p><br></p><p>
                    </p><p style="text-align: center;"><b><u>
                আমাদের লক্ষ্য</u></b></p><p style="text-align: center;"><b><u><br></u></b></p><p style="text-align: center;"><b><u>
                </u></b></p>


                <ul>
                    <li>
                        <b>একাডেমিক শ্রেষ্ঠত্ব : </b>
                        আমরা কঠোর একাডেমিক প্রোগ্রাম প্রদান করার চেষ্টা করি যা শিক্ষার্থীদের তাদের সর্বোচ্চ একাডেমিক সম্ভাবনা অর্জনের জন্য চ্যালেঞ্জ ও অনুপ্রাণিত করে।
                    </li>
                </ul>

                <ul>
                    <li>
                        <b> চরিত্র বিকাশ :</b>
                        আমরা আমাদের শিক্ষার্থীদের মধ্যে সততা, দায়িত্বশীলতা, সহানুভূতি এবং স্থিতিস্থাপকতার মতো দৃঢ় চরিত্রের বৈশিষ্ট্যের বিকাশে প্রতিশ্রুতিবদ্ধ।
                    </li>
                </ul>

                <ul>
                    <li>
                        <b>আজীবন শিক্ষা : </b>
                        আমাদের লক্ষ্য আমাদের শিক্ষার্থীদের মধ্যে শেখার প্রতি ভালবাসা এবং একটি বৃদ্ধির মানসিকতা জাগিয়ে তোলা, তাদের আজীবন শিক্ষার্থী হয়ে উঠতে ক্ষমতায়ন করা যারা কৌতূহলী, মানিয়ে নিতে পারে এবং নতুন ধারণা এবং সুযোগগুলি অন্বেষণ করতে আগ্রহী।
                    </li>
                </ul>

                <ul>
                    <li>
                        <b> সম্প্রদায় জড়িত :</b>
                        আমরা একটি সহায়ক এবং অন্তর্ভুক্তিমূলক শিক্ষার পরিবেশ তৈরি করতে পিতামাতা, পরিবার এবং বৃহত্তর সম্প্রদায়ের সাথে সক্রিয়ভাবে জড়িত থাকার চেষ্টা করি যা আমাদের শিক্ষার্থীদের সামগ্রিক বিকাশকে লালন করে। আমাদের মিশনে আমাদের সাথে যোগ দিন
                        আমরা আপনাকে পরবর্তী প্রজন্মের নেতা, চিন্তাবিদ এবং উদ্ভাবকদের অনুপ্রাণিত ও ক্ষমতায়িত করতে আমাদের মিশনে আমাদের সাথে যোগ দেওয়ার জন্য আমন্ত্রণ জানাচ্ছি।
                    </li>
                </ul>

                <ul>
                    <li>
                        <b> উজ্জ্বল ভবিষ্যত গঠনে :</b>
                        একসাথে, আমরা আমাদের শিক্ষার্থীদের জীবনে একটি পরিবর্তন আনতে পারি এবং সবার জন্য একটি উজ্জ্বল ভবিষ্যত তৈরি করতে পারি।
                        এই নমুনা বিষয়বস্তু স্কুলের মিশন, মূল মান, লক্ষ্য এবং সেই লক্ষ্যগুলি অর্জনে অংশীদারদের যোগদানের জন্য একটি আমন্ত্রণ প্রদান করে। আপনার স্কুল পরিচালনার আবেদনের নির্দিষ্ট মিশন এবং মানগুলির সাথে সারিবদ্ধ করার জন্য আপনি এটিকে আরও কাস্টমাইজ করতে পারেন৷
                    </li>
                </ul>',

                'menu_show' => 'footer'
            ]
        ];

        foreach ($pages as $page) {
            $new = new Page();
            $new->name = $page['name'];
            $new->slug = $page['slug'];
            $new->content = $page['content'];
            $new->menu_show = $page['menu_show'];
            $new->save();
        }

        foreach ($pages as $key => $en_page) {
            $en = new PageTranslate();
            $en->page_id = $key+1;
            $en->locale = 'en';
            $en->name = $en_page['name'];
            $en->content = $en_page['content'];
            $en->save();
        }

        foreach ($bn_pages as $key => $bn_page) {
            $bn = new PageTranslate();
            $bn->page_id = $key+1;
            $bn->locale = 'bn';
            $bn->name = $bn_page['name'];
            $bn->content = $bn_page['content'];
            $bn->save();
        }
    }
}
