<?php

namespace App\Repositories\Library;

use App\Enums\Settings;
use App\Interfaces\Library\BookInterface;
use App\Models\Library\Book;
use Illuminate\Support\Facades\DB;
use App\Traits\CommonHelperTrait;
use App\Traits\ReturnFormatTrait;

class BookRepository implements BookInterface{

    use ReturnFormatTrait;
    use CommonHelperTrait;
    private $model;

    public function __construct(Book $model)
    {
        $this->model = $model;
    }

    public function all()
    {
        return $this->model->active()->get();
    }

    public function getAll()
    {
        return $this->model->orderBy('id', 'desc')->paginate(Settings::PAGINATE);
    }

    public function store($request)
    {
        DB::beginTransaction();
        try {
            $row                   = new $this->model;
            $row->name             = $request->name;
            $row->category_id      = $request->category;
            $row->code             = $request->code;
            $row->publisher_name   = $request->publisher_name;
            $row->author_name      = $request->author_name;
            $row->rack_no          = $request->rack_no;
            $row->price            = $request->price;
            $row->quantity         = $request->quantity;
            $row->status           = $request->status;
            $row->description      = $request->description;
            $row->save();

            DB::commit();
            return $this->responseWithSuccess(___('alert.created_successfully'), []);
        } catch (\Throwable $th) {
            DB::rollBack();
            return $this->responseWithError(___('alert.something_went_wrong_please_try_again'), []);
        }
    }

    public function show($id)
    {
        return $this->model->find($id);
    }

    public function update($request, $id)
    {
        DB::beginTransaction();
        try {
            $row                   = $this->model->findOrfail($id);
            $row->name             = $request->name;
            $row->category_id      = $request->category;
            $row->code             = $request->code;
            $row->publisher_name   = $request->publisher_name;
            $row->author_name      = $request->author_name;
            $row->rack_no          = $request->rack_no;
            $row->price            = $request->price;
            $row->quantity         = $request->quantity;
            $row->status           = $request->status;
            $row->description      = $request->description;
            $row->save();

            DB::commit();
            return $this->responseWithSuccess(___('alert.updated_successfully'), []);
        } catch (\Throwable $th) {
            DB::rollBack();
            return $this->responseWithError(___('alert.something_went_wrong_please_try_again'), []);
        }
    }

    public function destroy($id)
    {
        DB::beginTransaction();
        try {
            $row = $this->model->find($id);
            $row->delete();

            DB::commit();
            return $this->responseWithSuccess(___('alert.deleted_successfully'), []);
        } catch (\Throwable $th) {
            DB::rollBack();
            return $this->responseWithError(___('alert.something_went_wrong_please_try_again'), []);
        }
    }
}
