<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class LeaveRequestStoreRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    public function rules(): array
    {
        return [
            'student' => 'required|exists:users,id',
            'approval_status' => 'required',
            'leave_type' => 'required|exists:leave_types,id',
            'start_date' => 'required',
            'end_date' => 'required',
            'class' => 'required|exists:classes,id',
//            'section' => 'required|exists:sections,id',
            'description' => 'nullable|string|max:255',
            ''
        ];
    }
}
