<?php

namespace Modules\MainApp\Http\Requests\FAQ;

use Illuminate\Foundation\Http\FormRequest;

class UpdateRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, mixed>
     */
    public function rules()
    {
        return [
            'question'       => 'required|max:255|unique:frequently_asked_questions,question,'.Request()->id,
            'answer'         => 'required',
            'position'       => 'required',
            'status'         => 'required',
        ];
    }
}
