<?php

namespace Modules\MainApp\Database\Seeders;

use Illuminate\Database\Seeder;
use Modules\MainApp\Entities\Currency;

class CurrencySeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $currencies = [
            ['currency' => "US Dollar",                                     'code' => "USD",            'symbol' => "$"],
            ['currency' => "Canadian Dollar",                               'code' => "CAD",            'symbol' => "$"],
            ['currency' => "Euro",                                          'code' => "EUR",            'symbol' => "€"],
            ['currency' => "UAE Dirham",                                    'code' => "AED",            'symbol' => "د.إ.‏"],
            ['currency' => "Afghan Afghani",                                'code' => "AFN",            'symbol' => "؋"],
            ['currency' => "Albanian Lek",                                  'code' => "ALL",            'symbol' => "Lek"],
            ['currency' => "Armenian Dram",                                 'code' => "AMD",            'symbol' => "դր."],
            ['currency' => "Argentine Peso",                                'code' => "ARS",            'symbol' => "$"],
            ['currency' => "Australian Dollar",                             'code' => "AUD",            'symbol' => "$"],
            ['currency' => "Azerbaijani Manat",                             'code' => "AZN",            'symbol' => "ман."],
            ['currency' => "Bosnia-Herzegovina Convertible Mark",           'code' => "BAM",            'symbol' => "KM"],
            ['currency' => "Bangladeshi Taka",                              'code' => "BDT",            'symbol' => "৳"],
            ['currency' => "Bulgarian Lev",                                 'code' => "BGN",            'symbol' => "лв."],
            ['currency' => "Bahraini Dinar",                                'code' => "BHD",            'symbol' => "د.ب.‏"],
            ['currency' => "Burundian Franc",                               'code' => "BIF",            'symbol' => "FBu"],
            ['currency' => "Brunei Dollar",                                 'code' => "BND",            'symbol' => "$"],
            ['currency' => "Bolivian Boliviano",                            'code' => "BOB",            'symbol' => "Bs"],
            ['currency' => "Brazilian Real",                                'code' => "BRL",            'symbol' => "R$"],
            ['currency' => "Botswanan Pula",                                'code' => "BWP",            'symbol' => "P"],
            ['currency' => "Belarusian Ruble",                              'code' => "BYN",            'symbol' => "руб."],
            ['currency' => "Belize Dollar",                                 'code' => "BZD",            'symbol' => "$"],
            ['currency' => "Congolese Franc",                               'code' => "CDF",            'symbol' => "FrCD"],
            ['currency' => "Swiss Franc",                                   'code' => "CHF",            'symbol' => "CHF"],
            ['currency' => "Chilean Peso",                                  'code' => "CLP",            'symbol' => "$"],
            ['currency' => "Chinese Yuan",                                  'code' => "CNY",            'symbol' => "CN¥"],
            ['currency' => "Colombian Peso",                                'code' => "COP",            'symbol' => "$"],
            ['currency' => "Costa Rican Colón",                             'code' => "CRC",            'symbol' => "₡"],
            ['currency' => "Cape Verdean Escudo",                           'code' => "CVE",            'symbol' => "CV$"],
            ['currency' => "Czech Republic Koruna",                         'code' => "CZK",            'symbol' => "Kč"],
            ['currency' => "Djiboutian Franc",                              'code' => "DJF",            'symbol' => "Fdj"],
            ['currency' => "Danish Krone",                                  'code' => "DKK",            'symbol' => "kr"],
            ['currency' => "Dominican Peso",                                'code' => "DOP",            'symbol' => "RD$"],
            ['currency' => "Algerian Dinar",                                'code' => "DZD",            'symbol' => "د.ج.‏"],
            ['currency' => "Estonian Kroon",                                'code' => "EEK",            'symbol' => "kr"],
            ['currency' => "Egyptian Pound",                                'code' => "EGP",            'symbol' => "ج.م.‏"],
            ['currency' => "Eritrean Nakfa",                                'code' => "ERN",            'symbol' => "Nfk"],
            ['currency' => "Ethiopian Birr",                                'code' => "ETB",            'symbol' => "Br"],
            ['currency' => "British Pound Sterling",                        'code' => "GBP",            'symbol' => "£"],
            ['currency' => "Georgian Lari",                                 'code' => "GEL",            'symbol' => "GEL"],
            ['currency' => "Ghanaian Cedi",                                 'code' => "GHS",            'symbol' => "GH₵"],
            ['currency' => "Guinean Franc",                                 'code' => "GNF",            'symbol' => "FG"],
            ['currency' => "Guatemalan Quetzal",                            'code' => "GTQ",            'symbol' => "Q"],
            ['currency' => "Hong Kong Dollar",                              'code' => "HKD",            'symbol' => "$"],
            ['currency' => "Honduran Lempira",                              'code' => "HNL",            'symbol' => "L"],
            ['currency' => "Croatian Kuna",                                 'code' => "HRK",            'symbol' => "kn"],
            ['currency' => "Hungarian Forint",                              'code' => "HUF",            'symbol' => "Ft"],
            ['currency' => "Indonesian Rupiah",                             'code' => "IDR",            'symbol' => "Rp"],
            ['currency' => "Indian Rupee",                                  'code' => "INR",            'symbol' => "₹"],
            ['currency' => "Iraqi Dinar",                                   'code' => "IQD",            'symbol' => "د.ع.‏"],
            ['currency' => "Iranian Rial",                                  'code' => "IRR",            'symbol' => "﷼"],
            ['currency' => "Icelandic Króna",                               'code' => "ISK",            'symbol' => "kr"],
            ['currency' => "Jamaican Dollar",                               'code' => "JMD",            'symbol' => "$"],
            ['currency' => "Jordanian Dinar",                               'code' => "JOD",            'symbol' => "د.أ.‏"],
            ['currency' => "Japanese Yen",                                  'code' => "JPY",            'symbol' => "￥"],
            ['currency' => "Kenyan Shilling",                               'code' => "KES",            'symbol' => "Ksh"],
            ['currency' => "Cambodian Riel",                                'code' => "KHR",            'symbol' => "៛"],
            ['currency' => "Comorian Franc",                                'code' => "KMF",            'symbol' => "FC"],
            ['currency' => "South Korean Won",                              'code' => "KRW",            'symbol' => "₩"],
            ['currency' => "Kuwaiti Dinar",                                 'code' => "KWD",            'symbol' => "د.ك.‏"],
            ['currency' => "Kazakhstani Tenge",                             'code' => "KZT",            'symbol' => "тңг."],
            ['currency' => "Lebanese Pound",                                'code' => "LBP",            'symbol' => "ل.ل.‏"],
            ['currency' => "Sri Lankan Rupee",                              'code' => "LKR",            'symbol' => "SL Re"],
            ['currency' => "Lithuanian Litas",                              'code' => "LTL",            'symbol' => "Lt"],
            ['currency' => "Latvian Lats",                                  'code' => "LVL",            'symbol' => "Ls"],
            ['currency' => "Libyan Dinar",                                  'code' => "LYD",            'symbol' => "د.ل.‏"],
            ['currency' => "Moroccan Dirham",                               'code' => "MAD",            'symbol' => "د.م.‏"],
            ['currency' => "Moldovan Leu",                                  'code' => "MDL",            'symbol' => "MDL"],
            ['currency' => "Malagasy Ariary",                               'code' => "MGA",            'symbol' => "MGA"],
            ['currency' => "Macedonian Denar",                              'code' => "MKD",            'symbol' => "MKD"],
            ['currency' => "Myanma Kyat",                                   'code' => "MMK",            'symbol' => "K"],
            ['currency' => "Macanese Pataca",                               'code' => "MOP",            'symbol' => "MOP$"],
            ['currency' => "Mauritian Rupee",                               'code' => "MUR",            'symbol' => "MURs"],
            ['currency' => "Mexican Peso",                                  'code' => "MXN",            'symbol' => "$"],
            ['currency' => "Malaysian Ringgit",                             'code' => "MYR",            'symbol' => "RM"],
            ['currency' => "Mozambican Metical",                            'code' => "MZN",            'symbol' => "MTn"],
            ['currency' => "Namibian Dollar",                               'code' => "NAD",            'symbol' => "N$"],
            ['currency' => "Nigerian Naira",                                'code' => "NGN",            'symbol' => "₦"],
            ['currency' => "Nicaraguan Córdoba",                            'code' => "NIO",            'symbol' => "C$"],
            ['currency' => "Norwegian Krone",                               'code' => "NOK",            'symbol' => "kr"],
            ['currency' => "Nepalese Rupee",                                'code' => "NPR",            'symbol' => "नेरू"],
            ['currency' => "New Zealand Dollar",                            'code' => "NZD",            'symbol' => "$"],
            ['currency' => "Omani Rial",                                    'code' => "OMR",            'symbol' => "ر.ع.‏"],
            ['currency' => "Panamanian Balboa",                             'code' => "PAB",            'symbol' => "B/."],
            ['currency' => "Peruvian Nuevo Sol",                            'code' => "PEN",            'symbol' => "S/."],
            ['currency' => "Philippine Peso",                               'code' => "PHP",            'symbol' => "₱"],
            ['currency' => "Pakistani Rupee",                               'code' => "PKR",            'symbol' => "₨"],
            ['currency' => "Polish Zloty",                                  'code' => "PLN",            'symbol' => "zł"],
            ['currency' => "Paraguayan Guarani",                            'code' => "PYG",            'symbol' => "₲"],
            ['currency' => "Qatari Rial",                                   'code' => "QAR",            'symbol' => "ر.ق.‏"],
            ['currency' => "Romanian Leu",                                  'code' => "RON",            'symbol' => "RON"],
            ['currency' => "Serbian Dinar",                                 'code' => "RSD",            'symbol' => "дин."],
            ['currency' => "Russian Ruble",                                 'code' => "RUB",            'symbol' => "₽."],
            ['currency' => "Rwandan Franc",                                 'code' => "RWF",            'symbol' => "FR"],
            ['currency' => "Saudi Riyal",                                   'code' => "SAR",            'symbol' => "ر.س.‏"],
            ['currency' => "Sudanese Pound",                                'code' => "SDG",            'symbol' => "SDG"],
            ['currency' => "Swedish Krona",                                 'code' => "SEK",            'symbol' => "kr"],
            ['currency' => "Singapore Dollar",                              'code' => "SGD",            'symbol' => "$"],
            ['currency' => "Somali Shilling",                               'code' => "SOS",            'symbol' => "Ssh"],
            ['currency' => "Syrian Pound",                                  'code' => "SYP",            'symbol' => "ل.س.‏"],
            ['currency' => "Thai Baht",                                     'code' => "THB",            'symbol' => "฿"],
            ['currency' => "Tunisian Dinar",                                'code' => "TND",            'symbol' => "د.ت.‏"],
            ['currency' => "Tongan Pa'anga",                                'code' => "TOP",            'symbol' => "T$"],
            ['currency' => "Turkish Lira",                                  'code' => "TRY",            'symbol' => "TL"],
            ['currency' => "Trinidad and Tobago Dollar",                    'code' => "TTD",            'symbol' => "$"],
            ['currency' => "New Taiwan Dollar",                             'code' => "TWD",            'symbol' => "NT$"],
            ['currency' => "Tanzanian Shilling",                            'code' => "TZS",            'symbol' => "TSh"],
            ['currency' => "Ukrainian Hryvnia",                             'code' => "UAH",            'symbol' => "₴"],
            ['currency' => "Ugandan Shilling",                              'code' => "UGX",            'symbol' => "USh"],
            ['currency' => "Uruguayan Peso",                                'code' => "UYU",            'symbol' => "$"],
            ['currency' => "Uzbekistan Som",                                'code' => "UZS",            'symbol' => "UZS"],
            ['currency' => "Venezuelan Bolívar",                            'code' => "VEF",            'symbol' => "Bs.F."],
            ['currency' => "Vietnamese Dong",                               'code' => "VND",            'symbol' => "₫"],
            ['currency' => "CFA Franc BEAC",                                'code' => "XAF",            'symbol' => "FCFA"],
            ['currency' => "CFA Franc BCEAO",                               'code' => "XOF",            'symbol' => "CFA"],
            ['currency' => "Yemeni Rial",                                   'code' => "YER",            'symbol' => "ر.ي.‏"],
            ['currency' => "South African Rand",                            'code' => "ZAR",            'symbol' => "R"],
            ['currency' => "Zambian Kwacha",                                'code' => "ZMK",            'symbol' => "ZK"],
            ['currency' => "Zimbabwean Dollar",                             'code' => "ZWL",            'symbol' => "ZWL$"],
        ];


        foreach($currencies as $currency) {
            Currency::firstOrCreate([
                'currency'  => $currency['currency'],
                'code'      => $currency['code'],
                'symbol'    => $currency['symbol'],
            ]);
        }
    }
}
