<?php

namespace Modules\LiveChat\Http\Controllers;

use App\Interfaces\UserInterface;
use App\Models\User;
use App\Traits\ApiReturnFormatTrait;
use Illuminate\Routing\Controller;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\View;
use Modules\LiveChat\Http\Requests\MessageRequest;
use Modules\LiveChat\Interfaces\LiveChatInterface;

class MessageController extends Controller
{
    use ApiReturnFormatTrait;

    protected $authUser;
    protected $users;
    protected $message;

    public function __construct(UserInterface $userInterface, LiveChatInterface $liveChatInterface)
    {
        $this->users = $userInterface;
        $this->message = $liveChatInterface;
    }

    public function chat($id)
    {
        $data['messages'] = $this->message->model()->UserReceiverIdOrReceiverUserId($id)->orderBy('created_at','ASC')->get();
        $data['title'] = ___('live_chat.Live_Chat');
        $data['user'] = $this->users->model()->with('image')->where('id', $id)->first();
        return view('livechat::message.index', compact('data'));
    }

    public function store(MessageRequest $request, $id)
    {

        try {
            $request->merge(['user_id' => $id]);
            $result = $this->message->store($request);
            if ($result->original['result']) {
                return $this->responseWithSuccess($result->original['message'], @showImage(auth()->user()->image->original)); // return success response
            } else {
                return $this->responseWithError(___('alert.something_went_wrong_please_try_again'), [], 400); // return error response
            }
        } catch (\Throwable $th) {
            return $this->responseWithError(___('alert.something_went_wrong_please_try_again'), [], 400); // return error response
        }
    }
    public function studentChat($id)
    {
        $this->message->readMessages($id);
        $data['messages'] = $this->message->model()->UserReceiverIdOrReceiverUserId($id)->orderBy('created_at','ASC')->get();
        $data['title'] = ___('live_chat.Live_Chat');
        $data['user'] = $this->users->model()->with('image')->where('id', $id)->first();
        return view('livechat::message.student', compact('data'));
    }

    public function studentStore(MessageRequest $request, $id)
    {

        try {
            $request->merge(['user_id' => $id]);
            $result = $this->message->store($request);
            if ($result->original['result']) {
                return $this->responseWithSuccess($result->original['message'], @showImage(auth()->user()->image->original)); // return success response
            } else {
                return $this->responseWithError(___('alert.something_went_wrong_please_try_again'), [], 400); // return error response
            }
        } catch (\Throwable $th) {
            return $this->responseWithError(___('alert.something_went_wrong_please_try_again'), [], 400); // return error response
        }
    }
    public function instructorChat($id)
    {
        $this->message->readMessages($id);
        $data['messages'] = $this->message->model()->UserReceiverIdOrReceiverUserId($id)->orderBy('created_at','ASC')->get();
        $data['title'] = ___('live_chat.Live_Chat');
        $data['user'] = $this->users->model()->with('image')->where('id', $id)->first();
        return view('livechat::message.instructor', compact('data'));
    }

    public function instructorStore(MessageRequest $request, $id)
    {

        try {
            $request->merge(['user_id' => $id]);
            $result = $this->message->store($request);
            if ($result->original['result']) {
                return $this->responseWithSuccess($result->original['message'], @showImage(auth()->user()->image->original)); // return success response
            } else {
                return $this->responseWithError(___('alert.something_went_wrong_please_try_again'), [], 400); // return error response
            }
        } catch (\Throwable $th) {
            return $this->responseWithError(___('alert.something_went_wrong_please_try_again'), [], 400); // return error response
        }
    }

    public function messageRead($id)
    {
        $this->message->readMessages($id);
        return $this->responseWithSuccess(___('live_chat.message_read_successfully'), []); // return success response
    }
}
